/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.token;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.internal.callable.CancelToken;
import com.tandbergtv.workflow.driver.internal.callable.SignalSuperProcessToken;
import com.tandbergtv.workflow.driver.internal.callable.UndoSuperProcessToken;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.exe.token.AbstractTokenHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public class End
extends AbstractTokenHandler {
    private static final long serialVersionUID = 2322699262929474682L;
    private static final Logger logger = Logger.getLogger(End.class);

    public void execute(ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)CustomToken.class.cast(context.getToken());
        if (token.getRequestedStatus() == ProcessStatus.CANCELLED) {
            this.cancel(token);
        } else {
            this.stop(token);
        }
    }

    private void stop(CustomToken token) {
        if (!token.isRoot()) {
            return;
        }
        CustomToken superProcessToken = this.getSuperProcessToken(token);
        if (superProcessToken == null) {
            return;
        }
        try {
            Future<CustomToken> future = this.callAndForget(new SignalSuperProcessToken(superProcessToken, false));
            future.get();
        }
        catch (Exception e) {
            try {
                Future<CustomToken> future = this.call(new SignalSuperProcessToken(superProcessToken, true));
                future.get();
            }
            catch (Exception e1) {
                logger.warn((Object)(token + " could not notify parent " + superProcessToken), (Throwable)e1);
            }
        }
    }

    private void cancel(CustomToken token) {
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken customToken : token.getActiveChildTokens()) {
            futures.add(this.cancelOne(customToken));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.warn((Object)(token + " interrupted while waiting"), (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.warn((Object)(token + ", execution failed"), (Throwable)e);
            }
        }
        WorkflowProcess workflowProcess = token.getSubProcessInstance();
        if (workflowProcess != null) {
            this.call(new CancelToken(workflowProcess.getRootToken()));
        }
        if (this.mustUndoSuperProcessToken(token)) {
            this.call(new UndoSuperProcessToken(token.getProcessInstance().getSuperProcessToken()));
        }
    }

    private boolean mustUndoSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        return token.isRoot() && process.getSuperProcessToken() != null && process.getContextInstance().hasTransientVariable("_undo_");
    }

    private Future<CustomToken> cancelOne(final CustomToken token) {
        final IProcessCounter counter = (IProcessCounter)((Object)this.getService().getStatistics().getCumulativeStatistics());
        return this.getScheduler().schedule((Callable)new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.cancel();
                counter.cancelled(token);
                return token;
            }
        });
    }

    private CustomToken getSuperProcessToken(CustomToken token) {
        CustomToken superProcessToken = token.getProcessInstance().getSuperProcessToken();
        if (superProcessToken == null) {
            return null;
        }
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        WorkflowProcess process = (WorkflowProcess)cache.get((Serializable)Long.valueOf(superProcessToken.getProcessInstance().getId()));
        if (process == null) {
            logger.info((Object)(token + ", parent " + superProcessToken + " has already completed"));
            return null;
        }
        if ((superProcessToken = process.findToken(superProcessToken.getId())) != null && superProcessToken.getSubProcessInstance() == null) {
            logger.warn((Object)(token + ", parent " + token.getProcessInstance().getSuperProcessToken() + " forgot about me :("));
            return null;
        }
        return superProcessToken;
    }
}

