/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.exe.ActionException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class AbstractAction
implements IExecutable {
    private static final long serialVersionUID = 1L;
    private boolean aborted;
    private Future<Void> future;

    public final void abort() {
        this.aborted = true;
        this.future.cancel(true);
    }

    public void cleanup() {
    }

    public final void execute(final ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() == ProcessStatus.ERROR || token.getRequestedStatus() == ProcessStatus.ERROR) {
            throw new ActionException(token + ", invalid status");
        }
        ISchedulerService scheduler = (ISchedulerService)ServiceRegistry.getDefault().lookup("message-thread");
        this.future = scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractAction.this.start(context);
                return null;
            }
        });
        try {
            this.future.get();
        }
        catch (CancellationException e) {
            if (this.aborted) {
                throw new ActionException("Execution was aborted", e);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ActionException) {
                throw (ActionException)e.getCause();
            }
            throw new ActionException(e.getCause());
        }
    }

    protected abstract void start(ExecutionContext var1);
}

