/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;

public class NotifySuperProcessToken
extends TokenCallable {
    private long childPid;
    private static final long serialVersionUID = 2429984887044821359L;

    public NotifySuperProcessToken(CustomToken token, boolean usePid) {
        super(token);
        this.childPid = token.getSubProcessInstance().getId();
        if (usePid) {
            this.key = Long.valueOf(this.getPid());
        }
    }

    @Override
    public CustomToken call() throws Exception {
        CustomToken token = this.findToken();
        if (!this.isSuperProcessToken(token)) {
            Logger.getLogger(NotifySuperProcessToken.class).warn((Object)(token + ", does not have child " + this.childPid));
            return token;
        }
        Node node = token.getCurrentNode();
        try {
            if (node instanceof ProcessState) {
                node.raiseException(new Throwable("Child process died"), (ExecutionContext)new com.tandbergtv.workflow.core.graph.exe.ExecutionContext((Token)token));
            }
        }
        catch (Throwable t) {
            Logger.getLogger(NotifySuperProcessToken.class).error((Object)token, t);
        }
        return token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        if (process == null) {
            return false;
        }
        return this.childPid == process.getId();
    }
}

