/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.IDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import java.lang.reflect.Constructor;

public class DispatcherFactory {
    private DispatcherFactory() {
    }

    public static DispatcherFactory newInstance() {
        return new DispatcherFactory();
    }

    public IDispatcher createDispatcher(IDispatcherConfiguration conf, IDestination dst) throws DispatcherException {
        IDispatcher dispatcher = null;
        String className = conf.getClassName();
        try {
            Class<?> clazz = conf.getClassLoader().loadClass(className);
            Constructor<?> constructor = clazz.getConstructor(IDispatcherConfiguration.class, IDestination.class);
            dispatcher = (IDispatcher)constructor.newInstance(conf, dst);
        }
        catch (Exception e) {
            throw new DispatcherException("Failed to create the dispatcher: " + className, e);
        }
        return dispatcher;
    }

    public IDispatcher createDispatcher(Class<?> clazz, IDispatcherConfiguration conf, IDestination dst) throws DispatcherException {
        IDispatcher dispatcher = null;
        String className = conf.getClassName();
        try {
            Constructor<?> constructor = clazz.getConstructor(IDispatcherConfiguration.class, IDestination.class);
            dispatcher = (IDispatcher)constructor.newInstance(conf, dst);
        }
        catch (Exception e) {
            throw new DispatcherException("Failed to create the dispatcher: " + className, e);
        }
        return dispatcher;
    }
}

