/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Deserializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipUtil {
    public static final String EXTENSION = ".zip";
    private static final Logger logger = Logger.getLogger(ZipUtil.class);

    public static void compress(File dir) throws IOException {
        ZipOutputStream os = ZipUtil.create(dir);
        ZipUtil.compress(os, dir);
        ZipUtil.close(os);
    }

    public static List<Object> read(File zip, Deserializer deserializer) throws IOException {
        if (zip.length() == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ZipFile zf = new ZipFile(zip);
        for (ZipEntry zipEntry : Collections.list(zf.entries())) {
            InputStream is = zf.getInputStream(zipEntry);
            Object obj = deserializer.deSerialize(zipEntry.getName(), is);
            if (obj != null) {
                list.add(obj);
            }
            is.close();
        }
        return list;
    }

    private static ZipOutputStream create(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        String name = dir.getAbsolutePath() + File.separator + dir.getName() + EXTENSION;
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(name));
        zos.setLevel(9);
        Logger.getLogger(ZipUtil.class).debug((Object)("Created zip file " + name));
        return zos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(ZipOutputStream out, File dir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(EXTENSION)) continue;
            byte[] buffer = new byte[8192];
            InputStream in = null;
            try {
                int len;
                out.putNextEntry(new ZipEntry(file.getName()));
                in = new BufferedInputStream(new FileInputStream(file));
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                out.closeEntry();
            }
        }
    }

    private static void close(ZipOutputStream zos) {
        try {
            zos.close();
        }
        catch (IOException e) {
            logger.warn((Object)":(", (Throwable)e);
        }
    }
}

