/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.JSONConverter;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class Deserializer {
    public Object deSerialize(String name, InputStream is) {
        Map<String, Object> fields = JSONConverter.read(is);
        if (fields.isEmpty()) {
            return null;
        }
        if (name.endsWith("-messageLog")) {
            return this.messageLog(fields);
        }
        if (name.endsWith("-resourceLog")) {
            return this.resourceLog(fields);
        }
        return this.nodeLog(fields);
    }

    private NodeLog nodeLog(Map<String, Object> fields) {
        Long id = (Long)fields.get("id");
        Long startTime = (Long)fields.get("startTime");
        Long endTime = (Long)fields.get("endTime");
        NodeLog result = new NodeLog(new Node("-"), new Date(startTime), new Date(endTime));
        this.setId((ProcessLog)result, id);
        return result;
    }

    private ProcessStatusPerResourceLog resourceLog(Map<String, Object> fields) {
        ProcessStatusPerResourceLog log = null;
        log = fields.get("queued") != null && Boolean.TRUE.equals(fields.get("queued")) ? new ProcessQueuedPerResourceLog() : new ProcessStatusPerResourceLog();
        if (this.hasField(fields, "tokenId")) {
            log.setTokenId(this.parseLong(fields, "tokenId"));
        }
        log.setNodeId(this.parseLong(fields, "nodeId"));
        log.setResourceGroupId(this.parseLong(fields, "resourceGroupId"));
        log.setResourceId(this.parseLong(fields, "resourceId"));
        log.setStartTime(this.parseDate(fields, "startTime"));
        log.setEndTime(this.parseDate(fields, "endTime"));
        log.setOperationalStatus(ProcessStatus.valueOf((String)((String)fields.get("operationalStatus"))));
        log.setAdminStatus(ProcessStatus.valueOf((String)((String)fields.get("adminStatus"))));
        return log;
    }

    private WorkflowMessageLog messageLog(Map<String, Object> deserialized) {
        WorkflowMessageLog result = new WorkflowMessageLog();
        result.setMessageUID((String)deserialized.get("messageUID"));
        result.setMessageType((String)deserialized.get("messageType"));
        result.setMessageName((String)deserialized.get("messageName"));
        result.setMessage((String)deserialized.get("message"));
        result.setIncoming((Boolean)deserialized.get("incoming"));
        result.setTimestamp(new Date((Long)deserialized.get("timestamp")));
        result.setResource(deserialized.get("resourceId") != null && !"".equals(deserialized.get("resourceId")) ? new Resource(new Long(deserialized.get("resourceId").toString()).longValue()) : null);
        result.setId((Long)deserialized.get("id"));
        return result;
    }

    private void setId(ProcessLog processLog, Long value) {
        try {
            Field field = ProcessLog.class.getDeclaredField("id");
            field.setAccessible(true);
            field.set(processLog, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean hasField(Map<String, Object> fields, String field) {
        return fields.containsKey(field);
    }

    private Date parseDate(Map<String, Object> fields, String field) {
        return new Date(this.parseLong(fields, field));
    }

    private Long parseLong(Map<String, Object> fields, String field) {
        return Long.valueOf(fields.get(field).toString());
    }
}

