/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogEventListener;
import com.tandbergtv.workflow.log.SortColumnEnum;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.FileNameMatcher;
import com.tandbergtv.workflow.log.file.GarbageCollector;
import com.tandbergtv.workflow.log.file.JSONConverter;
import com.tandbergtv.workflow.log.file.LogFileNames;
import com.tandbergtv.workflow.log.file.LogReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class WorkflowLogService
implements Service {
    private LogEventListener listener;
    private GarbageCollector collector;
    private Scheduler<Void> scheduler;
    private String dir;
    private long period;

    public WorkflowLogService(SessionFactory factory, String rootdir, Long period, Long window) {
        Finder finder = new Finder(factory);
        this.listener = new LogEventListener(new EventSerializer(rootdir));
        this.collector = new GarbageCollector(rootdir, window, finder);
        this.scheduler = new Scheduler("log-delete", 1, 1);
        this.period = period;
        this.dir = rootdir;
    }

    public void start() {
        this.scheduler.start();
        this.scheduler.schedule((Runnable)this.collector, 0L, this.period * 1000L);
        DefaultMediator.getInstance().register((IColleague)this.listener);
    }

    public void stop() {
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this.listener);
    }

    public String getServiceName() {
        return "process-logger";
    }

    private boolean hasLogs(long id) {
        File f = new File(Directories.pathFor(this.dir, id));
        return f.exists() && f.isDirectory();
    }

    private File zipFile(long id) {
        return new File(Directories.directoryFor(this.dir, id), id + ".zip");
    }

    public List<NodeLog> findNodeLogs(WorkflowProcess process, Integer count, Integer start) {
        if (!this.hasLogs(process.getId())) {
            return null;
        }
        if (count == null) {
            start = 0;
            count = 25;
        }
        if (this.zipFile(process.getId()).exists()) {
            Set<Long> nodes = this.nodeIds(process.getProcessDefinition());
            List<NodeLog> list = this.readLogs(process.getId(), nodes);
            int end = list.size() - start < count ? list.size() : start + count;
            return list.subList(start, end);
        }
        ArrayList<NodeLog> result = new ArrayList<NodeLog>();
        File[] allLogFiles = this.getNodeLogFiles(process);
        LogFileNames.sortFiles(allLogFiles, null, false);
        File[] currentPage = new File[allLogFiles.length - start < count ? allLogFiles.length - start : count];
        System.arraycopy(allLogFiles, start, currentPage, 0, currentPage.length);
        for (File file : currentPage) {
            NodeLog nodeLog = this.deSerializeNodeLog(file);
            if (nodeLog == null) continue;
            result.add(nodeLog);
        }
        return result;
    }

    public Integer getNodeLogCount(WorkflowProcess process) {
        if (!this.hasLogs(process.getId())) {
            return null;
        }
        if (this.zipFile(process.getId()).exists()) {
            return this.readLogs(process.getId(), this.nodeIds(process.getProcessDefinition())).size();
        }
        return this.getNodeLogFiles(process).length;
    }

    private List<NodeLog> readLogs(long id, Set<Long> nodes) {
        List<ProcessLog> list = new LogReader(this.dir).getLogs(NodeLog.class, id);
        ArrayList<NodeLog> copy = new ArrayList<NodeLog>();
        this.filter(list, nodes);
        for (ProcessLog log : list) {
            copy.add((NodeLog)log);
        }
        return copy;
    }

    private void filter(List<ProcessLog> list, Set<Long> nodes) {
        Iterator<ProcessLog> i = list.iterator();
        while (i.hasNext()) {
            NodeLog log = (NodeLog)i.next();
            Long nodeId = Long.valueOf(log.getNode().getName());
            if (nodes.contains(nodeId)) continue;
            i.remove();
        }
    }

    private File[] getNodeLogFiles(WorkflowProcess process) {
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, process.getId())), this.matchByType("-nodeLog"));
        int numFiles = 0;
        for (int i = 0; i < files.length; ++i) {
            if (this.skipDeserialize(process, files[i])) continue;
            files[numFiles] = files[i];
            ++numFiles;
        }
        File[] deserializableFiles = new File[numFiles];
        System.arraycopy(files, 0, deserializableFiles, 0, numFiles);
        return deserializableFiles;
    }

    private NodeLog deSerializeNodeLog(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            return (NodeLog)new Deserializer(file.getName(), is).deserialize();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private Set<Long> nodeIds(WorkflowTemplate template) {
        HashSet<Long> set = new HashSet<Long>();
        for (Node node : template.getNodes()) {
            set.add(node.getId());
        }
        return set;
    }

    private Node findNodeById(final long nodeId, WorkflowTemplate processDefinition) {
        final ArrayList result = new ArrayList();
        processDefinition.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                if (nodeId == node.getId()) {
                    result.add(node);
                }
            }
        });
        if (result.size() > 0) {
            return (Node)result.get(0);
        }
        return null;
    }

    private boolean skipDeserialize(WorkflowProcess process, File file) {
        Map<String, Object> deserialized = JSONConverter.read(file);
        if (deserialized.isEmpty()) {
            return true;
        }
        Integer nodeId = (Integer)deserialized.get("nodeId");
        return this.findNodeById(nodeId.intValue(), process.getProcessDefinition()) == null;
    }

    public List<WorkflowMessageLog> findMessageLogs(long id, long time, Integer count, Integer start, String sortColumn, Boolean descending) {
        if (!this.hasLogs(id)) {
            return null;
        }
        if (count == null || start == null || sortColumn == null || descending == null) {
            count = Integer.MAX_VALUE;
            start = 0;
            sortColumn = SortColumnEnum.timestamp.toString();
            descending = Boolean.TRUE;
        }
        ArrayList<WorkflowMessageLog> result = new ArrayList<WorkflowMessageLog>();
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        File[] files = this.getPreviousMessageLogFiles(id, time, tokenIdAndNodeId[0], tokenIdAndNodeId[1]);
        if (files != null && files.length > 0) {
            LogFileNames.sortFiles(files, sortColumn, descending);
            File[] currentPage = new File[files.length - start < count ? files.length - start : count];
            System.arraycopy(files, start, currentPage, 0, currentPage.length);
            for (File file : currentPage) {
                MessageLog log = (MessageLog)new Deserializer(file).deserialize();
                if (log.getLog() == null) continue;
                result.add(log.getLog());
            }
        }
        return result;
    }

    public Integer getMessageLogsCount(long id, long time) {
        if (!this.hasLogs(id)) {
            return null;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        long tokenId = tokenIdAndNodeId[0];
        long nodeId = tokenIdAndNodeId[1];
        File[] files = this.getPreviousMessageLogFiles(id, time, tokenId, nodeId);
        return files.length;
    }

    private File[] getPreviousMessageLogFiles(long id, final long time, final long tokenId, final long nodeId) {
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                if (name.endsWith("-resourceLog")) {
                    return false;
                }
                long fileTokenId = LogFileNames.getTokenId(name);
                long fileNodeId = LogFileNames.getNodeId(name);
                long timestamp = LogFileNames.extractFileTimestamp(name);
                return fileTokenId == tokenId && fileNodeId == nodeId && timestamp <= time;
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        LogFileNames.sortFiles(files, null, true);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            String name = file.getName();
            if (name.endsWith("-messageLog")) {
                result.add(0, file);
                continue;
            }
            if (name.endsWith("-nodeLog") && LogFileNames.extractFileTimestamp(name) < time) break;
        }
        return result.toArray(new File[result.size()]);
    }

    private long[] getTokenIdAndNodeId(long id, long prefix) {
        File file = this.getLogFileByPrefix(id, prefix);
        long tokenId = LogFileNames.getTokenId(file.getName());
        long nodeId = LogFileNames.getNodeId(file.getName());
        return new long[]{tokenId, nodeId};
    }

    private File getLogFileByPrefix(long id, final long prefix) {
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return name.startsWith(prefix + "-") && (name.endsWith("-nodeLog") || name.endsWith("-messageLog"));
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public Long getCurrentNodeMessageLogId(long id, final long tokenId, final long nodeId) {
        if (!this.hasLogs(id)) {
            return null;
        }
        String directoryPath = Directories.pathFor(this.dir, id);
        File dir = new File(directoryPath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(tokenId + "-" + nodeId + "-nodeLog") || name.endsWith(tokenId + "-" + nodeId + "-messageLog");
            }
        });
        if (files != null && files.length > 0) {
            LogFileNames.sortFiles(files, null, true);
            long latestNodeLogOrMessageLogId = -1L;
            if (files[0].getName().endsWith("-messageLog")) {
                latestNodeLogOrMessageLogId = LogFileNames.extractFileTimestamp(files[0].getName());
            }
            return latestNodeLogOrMessageLogId;
        }
        return new Long(-1L);
    }

    public int getNodeIteration(long id, final long time) {
        if (!this.hasLogs(id)) {
            return -1;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        final long tokenId = tokenIdAndNodeId[0];
        final long nodeId = tokenIdAndNodeId[1];
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                if (name.endsWith("-nodeLog")) {
                    long fileTokenId = LogFileNames.getTokenId(name);
                    long fileNodeId = LogFileNames.getNodeId(name);
                    Long timestamp = LogFileNames.extractFileTimestamp(name);
                    return fileTokenId == tokenId && fileNodeId == nodeId && timestamp <= time;
                }
                return false;
            }
        };
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), matcher);
        return files.length;
    }

    public int getNodeNumIterations(long id, long time) {
        if (!this.hasLogs(id)) {
            return -1;
        }
        long[] tokenIdAndNodeId = this.getTokenIdAndNodeId(id, time);
        long tokenId = tokenIdAndNodeId[0];
        long nodeId = tokenIdAndNodeId[1];
        File[] files = Directories.list(new File(Directories.pathFor(this.dir, id)), this.matchByType("-nodeLog"), this.matchByNode(tokenId, nodeId));
        return files.length;
    }

    private FileNameMatcher matchByType(final String type) {
        return new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return name.endsWith(type);
            }
        };
    }

    private FileNameMatcher matchByNode(final long tokenId, final long nodeId) {
        return new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                return LogFileNames.getTokenId(name) == tokenId && LogFileNames.getNodeId(name) == nodeId;
            }
        };
    }
}

