/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogEventListener;
import com.tandbergtv.workflow.log.SortColumnEnum;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.GarbageCollector;
import com.tandbergtv.workflow.log.file.LogReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class WorkflowLogService
implements Service {
    private LogEventListener listener;
    private GarbageCollector collector;
    private Scheduler<Void> scheduler;
    private String dir;
    private long period;

    public WorkflowLogService(SessionFactory factory, String rootdir, Long period, Long window) {
        Finder finder = new Finder(factory);
        this.listener = new LogEventListener(new EventSerializer(rootdir));
        this.collector = new GarbageCollector(rootdir, window, finder);
        this.scheduler = new Scheduler("log-delete", 1, 1);
        this.period = period;
        this.dir = rootdir;
    }

    public void start() {
        this.scheduler.start();
        this.scheduler.schedule((Runnable)this.collector, 0L, this.period * 1000L);
        DefaultMediator.getInstance().register((IColleague)this.listener);
    }

    public void stop() {
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this.listener);
    }

    public String getServiceName() {
        return "process-logger";
    }

    public List<NodeLog> findNodeLogs(WorkflowProcess process, int start, int count) {
        if (!this.hasLogs(process.getId())) {
            return Collections.emptyList();
        }
        if (count == 0) {
            start = 0;
            count = 25;
        }
        List<NodeLog> list = this.getNodeLogs(process.getId());
        this.filterByNodeIDs(list, this.nodeIds(process.getProcessDefinition()));
        return this.subList(list, start, count);
    }

    public int getNodeLogCount(WorkflowProcess process) {
        if (!this.hasLogs(process.getId())) {
            return 0;
        }
        List<NodeLog> list = this.getNodeLogs(process.getId());
        this.filterByNodeIDs(list, this.nodeIds(process.getProcessDefinition()));
        return list.size();
    }

    public List<MessageLog> findMessageLogs(long id, long tokenId, long nodeId, long logid, int count, int start, String orderBy, final boolean descending) {
        if (!this.hasLogs(id)) {
            return Collections.emptyList();
        }
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        List<MessageLog> list = this.getMessageLogs(id, tokenId, nodeId, logid);
        final SortColumnEnum order = orderBy == null ? SortColumnEnum.timestamp : SortColumnEnum.valueOf(orderBy);
        Collections.sort(list, new Comparator<MessageLog>(){

            @Override
            public int compare(MessageLog m1, MessageLog m2) {
                return MessageLog.compare(m1, m2, order, descending);
            }
        });
        return this.subList(list, start, count);
    }

    public int getMessageLogsCount(long id, long tokenId, long nodeId, long logid) {
        if (!this.hasLogs(id)) {
            return 0;
        }
        return this.getMessageLogs(id, tokenId, nodeId, logid).size();
    }

    public long getCurrentNodeMessageLogId(long id, long tokenId, long nodeId) {
        if (!this.hasLogs(id)) {
            return 0L;
        }
        List<ProcessLog> logs = this.filterByTokenNode(this.getMessageLogs(id), tokenId, nodeId);
        if (logs.isEmpty()) {
            return 0L;
        }
        Collections.reverse(logs);
        return logs.get(0).getId();
    }

    public int getNodeIteration(long id, long tokenId, long nodeId, long logid) {
        if (!this.hasLogs(id)) {
            return 0;
        }
        List<ProcessLog> logs = this.filterByTokenNode(this.getLogs(id, NodeLog.class), tokenId, nodeId);
        return logs.indexOf(this.findById(logs, logid)) + 1;
    }

    public int getNodeNumIterations(long id, long tokenId, long nodeId) {
        if (!this.hasLogs(id)) {
            return -1;
        }
        return this.filterByTokenNode(this.getLogs(id, NodeLog.class), tokenId, nodeId).size();
    }

    private List<MessageLog> getMessageLogs(long id, long tokenId, long nodeId, long time) {
        ArrayList<MessageLog> logs = new ArrayList<MessageLog>();
        List<ProcessLog> list = this.filterByTokenNode(this.getLogs(id, this.types()), tokenId, nodeId);
        Collections.reverse(list);
        ProcessLog log = this.findById(list, time);
        int index = list.indexOf(log);
        for (int i = index + 1; i < list.size(); ++i) {
            ProcessLog l = list.get(i);
            if (l instanceof NodeLog) {
                return logs;
            }
            logs.add((MessageLog)((Object)MessageLog.class.cast(l)));
        }
        return logs;
    }

    private List<ProcessLog> filterByTokenNode(List<ProcessLog> logs, long tokenId, long nodeId) {
        ArrayList<ProcessLog> list = new ArrayList<ProcessLog>();
        for (ProcessLog l : logs) {
            long tid = l.getToken().getId();
            long nid = 0L;
            if (l instanceof NodeLog) {
                nid = Long.valueOf(((NodeLog)NodeLog.class.cast(l)).getNode().getName());
            } else if (l instanceof MessageLog) {
                nid = Long.valueOf(((MessageLog)((Object)MessageLog.class.cast(l))).getLog().getNode().getName());
            }
            if (tid != tokenId || nodeId != nid) continue;
            list.add(l);
        }
        return list;
    }

    private ProcessLog findById(List<ProcessLog> logs, long id) {
        for (ProcessLog log : logs) {
            if (!(log instanceof NodeLog) || log.getId() != id) continue;
            return log;
        }
        return null;
    }

    private void filterByNodeIDs(List<NodeLog> list, Set<Long> nodes) {
        Iterator<NodeLog> i = list.iterator();
        while (i.hasNext()) {
            NodeLog log = i.next();
            Long nodeId = Long.valueOf(log.getNode().getName());
            if (nodes.contains(nodeId)) continue;
            i.remove();
        }
    }

    private Set<Long> nodeIds(WorkflowTemplate template) {
        final HashSet<Long> set = new HashSet<Long>();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                set.add(node.getId());
            }
        });
        return set;
    }

    private Collection<Class<? extends ProcessLog>> types() {
        HashSet<Class<? extends ProcessLog>> types = new HashSet<Class<? extends ProcessLog>>();
        types.add(NodeLog.class);
        types.add(MessageLog.class);
        return types;
    }

    private List<NodeLog> getNodeLogs(long id) {
        List<ProcessLog> list = this.getLogs(id, NodeLog.class);
        ArrayList<NodeLog> copy = new ArrayList<NodeLog>();
        for (ProcessLog log : list) {
            copy.add((NodeLog)log);
        }
        return copy;
    }

    private List<ProcessLog> getMessageLogs(long id) {
        return this.getLogs(id, MessageLog.class);
    }

    private List<ProcessLog> getLogs(long id, Class<? extends ProcessLog> type) {
        return new LogReader(this.dir).getLogs(id, type);
    }

    private List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types) {
        return new LogReader(this.dir).getLogs(id, types);
    }

    public boolean hasLogs(long id) {
        File f = Directories.directoryFor(this.dir, id);
        return f.exists() && f.isDirectory();
    }

    private List<?> subList(List<?> list, int start, int count) {
        int end = list.size() - start < count ? list.size() : start + count;
        return list.subList(start, end);
    }
}

