/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueue;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.entity.ResourceGroupProxy;
import com.tandbergtv.workflow.resourcemanager.internal.entity.ResourceGroupQueueProxy;
import com.tandbergtv.workflow.resourcemanager.internal.entity.ResourceProxy;
import java.util.HashSet;

public class ResourceManagementCloneService
extends ResourceManagementService
implements ICloneService {
    @Override
    public ResourceType cloneResourceType(ResourceType resourceType) {
        if (resourceType == null) {
            return null;
        }
        return resourceType.clone();
    }

    @Override
    public Resource cloneResource(Resource resource) {
        return this.cloneResource(resource, true);
    }

    @Override
    public Resource cloneResource(Resource resource, boolean useProxy) {
        if (resource == null) {
            return null;
        }
        Resource clone = resource.clone();
        if (clone.getResourceGroups() != null) {
            HashSet<ResourceGroup> copiedGroups = new HashSet<ResourceGroup>();
            for (ResourceGroup group : resource.getResourceGroups()) {
                ResourceGroup copy = useProxy ? new ResourceGroupProxy(group.getId()) : new ResourceGroup(group.getId());
                copiedGroups.add(copy);
            }
            clone.setResourceGroups(copiedGroups);
        }
        return clone;
    }

    @Override
    public ResourceGroup cloneResourceGroup(ResourceGroup resourceGroup) {
        return this.cloneResourceGroup(resourceGroup, true);
    }

    @Override
    public ResourceGroup cloneResourceGroup(ResourceGroup resourceGroup, boolean useProxy) {
        return this.cloneResourceGroup(resourceGroup, useProxy, false);
    }

    @Override
    public ResourceGroup cloneResourceGroup(ResourceGroup resourceGroup, boolean useProxy, boolean useQueueProxy) {
        if (resourceGroup == null) {
            return null;
        }
        ResourceGroup clone = resourceGroup.clone();
        if (clone.getResources() != null) {
            HashSet<Resource> copiedResources = new HashSet<Resource>();
            for (Resource resource : clone.getResources()) {
                long id = resource.getId();
                Resource copy = useProxy ? new ResourceProxy(id) : new Resource(id);
                copiedResources.add(copy);
            }
            clone.setResources(copiedResources);
        }
        if (clone.getQueue() != null) {
            ResourceGroupQueue copiedQueue = !useQueueProxy ? clone.getQueue().clone() : new ResourceGroupQueueProxy(clone.getQueue());
            clone.setQueue(copiedQueue);
        }
        return clone;
    }
}

