/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.simulator;

import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SimulatorConfiguration {
    private static HashMap<String, WorkflowMessage> simulatorMessages = new HashMap(2);
    private static final SimulatorConfiguration simulatorConfiguration = new SimulatorConfiguration();
    private static Logger logger = Logger.getLogger((String)"SimulatorConfiguration");

    static {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("simulator.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String folder = properties.getProperty("simulator.folder");
        List<File> rtypefolders = SimulatorConfiguration.getFolders(new File(folder));
        if (folder != null) {
            for (File f : rtypefolders) {
                File[] files;
                String name = f.getName();
                if (name.startsWith("resourcetype_")) {
                    name = name.substring(13);
                }
                File[] fileArray = files = f.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    try {
                        Document document = XMLDocumentUtility.loadFile(String.valueOf(folder) + name + file.getName());
                        WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
                        String uidValue = message.getMessageUID().getUID();
                        if (uidValue != null) {
                            simulatorMessages.put(name, message);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Can not load simulator configuration file:" + file.getName()));
                    }
                    ++n2;
                }
            }
        }
    }

    public static SimulatorConfiguration newInstance() {
        return simulatorConfiguration;
    }

    private static List<File> getFolders(File folder) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                list.add(files[i]);
            }
            ++i;
        }
        return null;
    }

    public WorkflowMessage getMessage(String rtypeSysId) {
        return simulatorMessages.get(rtypeSysId);
    }

    public HashMap<String, WorkflowMessage> getMessages() {
        return simulatorMessages;
    }
}

