/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.settings;

import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;

public class SettingsPluginLoader {
    private static final Logger logger = Logger.getLogger(SettingsPluginLoader.class);
    private static final String SETTINGS_PROVIDER_EXTENSION_POINT = "settingsProvider";
    private static final String SETTINGS_PLUGIN = "com.tandbergtv.workflow.settings";

    public ISettingsProvider createSettingsProvider() {
        PluginManager pm = Platform.getPlatform().getPluginManager();
        ExtensionPoint point = null;
        try {
            point = pm.getRegistry().getExtensionPoint(SETTINGS_PLUGIN, SETTINGS_PROVIDER_EXTENSION_POINT);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading plugin: com.tandbergtv.workflow.settings", (Throwable)e);
        }
        ISettingsProvider provider = null;
        if (!point.getAvailableExtensions().isEmpty()) {
            Extension extension = (Extension)point.getAvailableExtensions().iterator().next();
            String className = extension.getParameter("class").valueAsString();
            PluginDescriptor desc = extension.getDeclaringPluginDescriptor();
            try {
                Class clazz = pm.getPluginClassLoader(desc).loadClass(className);
                provider = (ISettingsProvider)clazz.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("Error loading settings from plugin: " + className), (Throwable)e);
            }
        }
        return provider;
    }
}

