/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.ResourceAllocationService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InternalResourceService
implements IInternalResourceService {
    private Set<Long> resourceGroupIds;
    private static final Logger logger = Logger.getLogger(ResourceAllocationService.class);
    private static final String RECOURCE_TYPE_IDS = "com.tandbergtv.workflow.resource.systemids";
    public static final String PLUGIN_SETTINGS_PATH = "com.tandbergtv.workflow.application";

    public String getServiceName() {
        return "resource-internal-service";
    }

    public void start() {
        this.resourceGroupIds = new HashSet<Long>();
        for (String systemId : this.getResourceTypes()) {
            this.buildResourceGroupList(systemId);
        }
    }

    private void buildResourceGroupList(String systemID) {
        ResourceManagement service = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        long resourceTypeId = service.getResourceTypeBySystemId(systemID).getId();
        List resourceGroups = service.getResourceGroupsByResourceType(resourceTypeId);
        for (ResourceGroup g : resourceGroups) {
            logger.debug((Object)("for " + systemID + " added " + g.getName()));
            this.resourceGroupIds.add(g.getId());
        }
    }

    private Collection<String> getResourceTypes() {
        SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
        ISettingsProvider provider = settingsPluginLoader.createSettingsProvider();
        if (provider == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.loadPropertyFromPlugin(provider).split(","));
    }

    public void stop() {
        this.resourceGroupIds.clear();
    }

    public boolean needsResource(long resourceGroupId) {
        return !this.resourceGroupIds.contains(resourceGroupId);
    }

    private String loadPropertyFromPlugin(ISettingsProvider provider) {
        return provider.getProperties(PLUGIN_SETTINGS_PATH).get(RECOURCE_TYPE_IDS);
    }
}

