/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.token;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.PauseToken;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.exe.token.AbstractTokenHandler;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public class Suspend
extends AbstractTokenHandler {
    private static final long serialVersionUID = -1369290087636316974L;
    private static final Logger logger = Logger.getLogger(Suspend.class);

    public void execute(ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)CustomToken.class.cast(context.getToken());
        ArrayList<Future<CustomToken>> futures = new ArrayList<Future<CustomToken>>();
        for (CustomToken customToken : token.getActiveChildTokens()) {
            futures.add(this.pause(customToken));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.warn((Object)(token + " interrupted while waiting"), (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.warn((Object)(token + ", execution failed"), (Throwable)e);
            }
        }
        WorkflowProcess workflowProcess = token.getSubProcessInstance();
        if (workflowProcess != null) {
            this.call(new PauseToken(workflowProcess.getRootToken()));
        }
    }

    private Future<CustomToken> pause(final CustomToken token) {
        final IProcessCounter counter = (IProcessCounter)((Object)this.getService().getStatistics().getCumulativeStatistics());
        return this.getScheduler().schedule((Callable)new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.suspend();
                counter.paused(token);
                return token;
            }
        });
    }
}

