/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.TokenError;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.Intent;
import com.tandbergtv.workflow.monitor.core.alarm.IntentAction;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ProcessAlarmNotification {
    private static final Logger logger = Logger.getLogger(ProcessAlarmNotification.class);
    public static final String ALARM_RECOVERY_URL = "/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    private AtomicInteger counter = new AtomicInteger(0);

    AlarmNotification buildAlarm(WorkflowProcess process) {
        TokenError error = process.getRootToken().getErrorDetails();
        ArrayList<CustomToken> failedTokens = new ArrayList<CustomToken>();
        if (error == null) {
            Collection childTokens = process.getRootToken().getChildTokens();
            long lStartTime = System.nanoTime();
            for (CustomToken token : childTokens) {
                if (token.getStatus() != ProcessStatus.ERROR) continue;
                if (token.getErrorDetails() != null) {
                    error = token.getErrorDetails();
                    break;
                }
                failedTokens.add(token);
            }
        }
        try {
            int seq = this.counter.getAndIncrement();
            AlarmNotification notification = this.createAlarmNotification(process, seq, error, failedTokens);
            if (notification != null) {
                URI recoveryUrl = new URI(ALARM_RECOVERY_URL + process.getId());
                if (process.getCanBeRetried()) {
                    notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Retry, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
                }
                if (process.getCanBeRestarted() && error.getCategory() != ErrorCategory.TIMEOUT) {
                    notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Restart, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
                }
                if (process.getCanBeCancelled()) {
                    notification.addAction(Intent.newInstance((IntentOperation)IntentOperation.Cancel, (IntentAction)IntentAction.Command, (URI)recoveryUrl));
                }
                return notification;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error occured building alarm for process " + process.getId()), (Throwable)e);
        }
        this.counter.getAndDecrement();
        return null;
    }

    private AlarmNotification createAlarmNotification(WorkflowProcess process, int sequenceNo, TokenError error, List<CustomToken> failedTokens) {
        if (error != null) {
            return new AlarmNotification((Object)process, (long)sequenceNo, AlarmSeverity.Error, error.getCategory().name(), error.getTime().getTime(), error.getMessage());
        }
        if (failedTokens != null && !failedTokens.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(CHILD_PROCESS_ERROR_MSG_PREFIX);
            Date errorDate = null;
            boolean first = true;
            for (CustomToken token : failedTokens) {
                if (errorDate == null || errorDate.before(token.getStart())) {
                    errorDate = token.getStart();
                }
                errorMessage.append(first ? " " : ", ").append(token.getNode().getName());
                first = false;
            }
            return new AlarmNotification((Object)process, (long)sequenceNo, AlarmSeverity.Error, ErrorCategory.CHILD_PROCESS_FAILED.toString(), errorDate.getTime(), errorMessage.toString());
        }
        return null;
    }
}

