/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class HibernatePersistenceService
implements IPersistenceService {
    private ICacheService<WorkflowProcess> cache;
    private SessionFactory factory;
    private static final Logger logger = Logger.getLogger(HibernatePersistenceService.class);
    private static final String SERVICE_NAME = "Process Persistence";

    public HibernatePersistenceService(SessionFactory factory) {
        this.factory = factory;
        this.cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    @Override
    public Serializable create(WorkflowProcess process) {
        Session session = this.getSession();
        Transaction t = null;
        WorkflowTemplate template = process.getProcessDefinition();
        CustomToken token = process.getRootToken();
        try {
            try {
                t = session.beginTransaction();
                session.saveOrUpdate((Object)process);
                CustomToken superProcessToken = process.getSuperProcessToken();
                WorkflowProcess parent = null;
                if (superProcessToken != null) {
                    parent = superProcessToken.getProcessInstance();
                    session.saveOrUpdate((Object)parent);
                }
                if (Cluster.owner((Object)process.getId())) {
                    this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
                } else {
                    this.updateCache(process);
                }
                t.commit();
                if (superProcessToken != null) {
                    this.cache.add((Serializable)Long.valueOf(parent.getId()), (Object)parent);
                    logger.info((Object)("[Process] " + token + ", template " + template.getFullName() + ", parent " + superProcessToken));
                } else {
                    logger.info((Object)("[Process] " + token + ", template " + template.getFullName()));
                }
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                logger.error((Object)("Failed to save the process " + process), (Throwable)e);
                if (process.getId() > 0L) {
                    this.cache.remove((Serializable)Long.valueOf(process.getId()));
                }
                throw new DriverRuntimeException("Failed to save the process", e);
            }
        }
        finally {
            this.closeSession(session);
        }
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ProcessPersistEvent(process, false));
        return Long.valueOf(process.getId());
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        WorkflowProcess process = (WorkflowProcess)this.cache.get(id);
        if (process != null) {
            return process;
        }
        Session session = this.getSession();
        try {
            process = (WorkflowProcess)session.load(WorkflowProcess.class, id);
        }
        finally {
            this.closeSession(session);
        }
        return process;
    }

    @Override
    public List<WorkflowProcess> getAll(List<String> ids) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        ArrayList<Long> noncachedIds = new ArrayList<Long>();
        for (String id : ids) {
            WorkflowProcess process = (WorkflowProcess)this.cache.get((Serializable)((Object)id));
            if (process != null) {
                processes.add(process);
                continue;
            }
            noncachedIds.add(Long.parseLong(id));
        }
        Session session = this.getSession();
        try {
            Query query = session.createQuery("SELECT wp FROM WorkflowProcess wp WHERE wp.id IN (:noncachedIds)");
            query.setParameterList("noncachedIds", noncachedIds);
            processes.addAll(query.list());
        }
        finally {
            this.closeSession(session);
        }
        return processes;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public CustomToken getToken(Serializable id) {
        Session session = this.getSession();
        Query query = session.createQuery("select p.id from WorkflowProcess p, CustomToken t where t.processInstance = p and t.id = ?");
        query.setParameter(0, (Object)id);
        try {
            Number number = (Number)query.uniqueResult();
            if (number != null) {
                long pid = number.longValue();
                CustomToken customToken = this.get(Long.valueOf(pid)).findToken(((Long)id).longValue());
                return customToken;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    @Override
    public void persist(WorkflowProcess process) {
        process.lock();
        try {
            this.doSave(process);
        }
        finally {
            process.unlock();
            if (process.hasEnded() || !process.isActive()) {
                this.cache.remove((Serializable)Long.valueOf(process.getId()));
            } else {
                this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
            }
        }
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    @Override
    public void save(WorkflowProcess process) {
        process.lock();
        try {
            long start = System.currentTimeMillis();
            this.cache.add((Serializable)Long.valueOf(process.getId()), (Object)process);
            logger.debug((Object)("Time taken to HibernatePersistenceService.save.add - time:" + (System.currentTimeMillis() - start)));
            if (!this.isTrace(process)) {
                return;
            }
            this.doSave(process);
        }
        finally {
            process.unlock();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private void closeSession(Session session) {
        if (session != null) {
            session.close();
        }
    }

    private void doSave(WorkflowProcess process) {
        Session session = this.getSession();
        Transaction t = null;
        try {
            try {
                t = session.beginTransaction();
                session.saveOrUpdate((Object)process);
                t.commit();
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ProcessPersistEvent(process, false));
            }
            catch (Exception e) {
                if (t != null) {
                    t.rollback();
                }
                logger.error((Object)("Failed to save the process " + process), (Throwable)e);
                throw new DriverRuntimeException("Failed to save the process", e);
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    private Session getSession() {
        return this.factory.openSession();
    }

    private boolean isTrace(WorkflowProcess process) {
        return process.getLogLevel() == LogLevel.ALL;
    }

    private void updateCache(WorkflowProcess process) {
        ConcurrentMap map = ((IDistributedCache)this.cache).getMap();
        map.put(process.getId(), process);
    }
}

