/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.variableinstance.DateInstance;
import org.jbpm.context.exe.variableinstance.StringInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.Token;

public class WfsEsProcessHelper {
    private static final String LICENSING_WINDOW_START = "licensingWindowStart";
    private static final String INGEST_TEMPLATE = "ingestTemplate";
    private static final String PROVIDER_ID = "provider_id";
    private static final String PROVIDERID = "providerId";
    private static final String LICENSING_WINDOW_END = "licensingWindowEnd";
    private static final String LICENSE_END = "license_end";
    private static final String LICENSEEND = "licenseEnd";
    private static final String LICENSE_START = "license_start";
    private static final String LICENSESTART = "licenseStart";
    private static final String TITLE_BRIEF = "title_brief";
    private static final String TITLEBRIEF = "titleBrief";
    private static final String TITLE_ID = "title_id";
    private static final String TITLEID = "titleId";
    private static Logger logger = Logger.getLogger(WfsEsProcessHelper.class);
    private static WfsEsProcessHelper instance = new WfsEsProcessHelper();
    private static final String TITLE_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final SimpleDateFormat titleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private static final SimpleDateFormat displayDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    private WfsEsProcessHelper() {
    }

    public static WfsEsProcessHelper getInstance() {
        return instance;
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            logger.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "processinstance", id);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void addSearchFields(XContentBuilder bldr, WorkflowProcess proc) {
        this.addSearchableField(bldr, "id", proc.getId());
        this.addSearchableField(bldr, "templateId", proc.getProcessDefinition().getId());
        this.addSearchableField(bldr, "templateName", proc.getProcessDefinition().getFullName());
        this.addSearchableField(bldr, "adminStatus", proc.getRootToken().getRequestedStatus());
        this.addSearchableField(bldr, "status", proc.getRootToken().getStatus());
        this.addSearchableField(bldr, "priority", proc.getPriority());
        TokenVariableMap tMap = proc.getContextInstance().getTokenVariableMap((Token)proc.getRootToken());
        HashSet variableSet = new HashSet();
        try {
            variableSet.addAll(tMap.getVariables().keySet());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String varName : variableSet) {
            Date dtVal;
            if (TITLEID.equalsIgnoreCase(varName) || TITLE_ID.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, TITLEID, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (TITLEBRIEF.equalsIgnoreCase(varName) || TITLE_BRIEF.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, TITLEBRIEF, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (LICENSESTART.equalsIgnoreCase(varName) || LICENSE_START.equalsIgnoreCase(varName) || LICENSING_WINDOW_START.equalsIgnoreCase(varName)) {
                dtVal = null;
                if (tMap.getVariableInstance(varName) instanceof DateInstance) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if (tMap.getVariableInstance(varName) instanceof StringInstance) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal == null) continue;
                this.addSearchableField(bldr, LICENSESTART, dtVal);
                continue;
            }
            if (LICENSEEND.equalsIgnoreCase(varName) || LICENSE_END.equalsIgnoreCase(varName) || LICENSING_WINDOW_END.equalsIgnoreCase(varName)) {
                dtVal = null;
                if (tMap.getVariableInstance(varName) instanceof DateInstance) {
                    dtVal = (Date)tMap.getVariableInstance(varName).getValue();
                } else if (tMap.getVariableInstance(varName) instanceof StringInstance) {
                    dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
                }
                if (dtVal == null) continue;
                this.addSearchableField(bldr, LICENSEEND, dtVal);
                continue;
            }
            if (PROVIDERID.equalsIgnoreCase(varName) || PROVIDER_ID.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, PROVIDERID, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (!INGEST_TEMPLATE.equalsIgnoreCase(varName)) continue;
            this.addSearchableField(bldr, INGEST_TEMPLATE, tMap.getVariableInstance(varName).getValue());
        }
        this.addSearchableField(bldr, "isActive", proc.isActive());
        this.addSearchableField(bldr, "currentTask", proc.getRootToken().getCurrentNode().getName());
        if (proc.getStart() != null) {
            this.addSearchableField(bldr, "startTime", proc.getStart());
        }
        if (proc.getEnd() != null) {
            this.addSearchableField(bldr, "endTime", proc.getEnd());
        }
        if (proc.getSuperProcessToken() != null) {
            this.addSearchableField(bldr, "superProcessTokenId", proc.getSuperProcessToken().getId());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (proc.getRootToken().getChildren() != null && proc.getRootToken().getChildren().size() > 0) {
            this.addSearchableField(bldr, "hasChildren", true);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
        }
        this.addSearchableField(bldr, "rootTokenId", proc.getRootToken().getId());
        if (proc.getRootToken().getErrorDetails() != null) {
            this.addSearchableField(bldr, "errorTime", proc.getRootToken().getErrorDetails().getTime());
            this.addSearchableField(bldr, "errorComment", proc.getRootToken().getErrorDetails().getMessage());
            this.addSearchableField(bldr, "errorType", proc.getRootToken().getErrorDetails().getCategory());
        }
    }

    private Date convertTitleStringToDate(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = titleDateFormat.parse(date);
            }
            catch (ParseException e) {
                logger.warn((Object)("Date received from Title Service [" + date + "] is not in correct format. Expected format :" + TITLE_DATE_FORMAT), (Throwable)e);
            }
        }
        return retVal;
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            bldr.field(key, value);
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot add field", (Throwable)ex);
        }
    }

    public void addResultProperties(SearchRequestBuilder bld) {
        bld.addField("id");
        bld.addField("hasChildren");
        bld.addField("rootTokenId");
        bld.addField("superProcessTokenId");
        bld.addField(PROVIDERID);
        bld.addField("templateId");
        bld.addField("templateName");
        bld.addField("adminStatus");
        bld.addField("status");
        bld.addField(TITLEID);
        bld.addField(TITLEBRIEF);
        bld.addField(LICENSESTART);
        bld.addField(LICENSEEND);
        bld.addField("currentTask");
        bld.addField("startTime");
        bld.addField("endTime");
        bld.addField("errorTime");
        bld.addField("errorComment");
        bld.addField(INGEST_TEMPLATE);
        bld.addField("isActive");
        bld.addField("priority");
        bld.addField("errorType");
    }

    public long getLongField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1L : Long.parseLong(value.toString());
    }

    public String getStringField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? "" : value.toString();
    }

    public int getIntField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public Date getDateField(SearchHit hit, String fieldName) throws ParseException {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateformatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return value == null ? null : dateformatter.parse(value.toString());
    }

    public boolean getBooleanField(SearchHit hit, String fieldName) {
        SearchHitField field = hit.field(fieldName);
        Object value = field == null ? null : field.getValue();
        return value == null ? false : Boolean.parseBoolean(value.toString());
    }

    public WFSearchResult convert(SearchHit hit, long totalCount) {
        if (hit == null) {
            throw new IllegalArgumentException("SearchHit is null");
        }
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(this.getLongField(hit, "id"));
        if (!this.getStringField(hit, "priority").isEmpty()) {
            result.setPriority(ProcessPriority.valueOf((String)this.getStringField(hit, "priority")).ordinal());
        }
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(this.getLongField(hit, "rootTokenId"));
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "adminStatus")).ordinal());
        rootToken.setOperationalStatus(ProcessStatus.valueOf((String)this.getStringField(hit, "status")).ordinal());
        rootToken.setNodeName(this.getStringField(hit, "currentTask"));
        try {
            rootToken.setStartTime(this.getDateField(hit, "startTime"));
            rootToken.setEndTime(this.getDateField(hit, "endTime"));
            rootToken.setErrorTime(this.getDateField(hit, "errorTime"));
            rootToken.setErrorComment(this.getStringField(hit, "errorComment"));
            if (!this.getStringField(hit, "errorType").isEmpty()) {
                rootToken.setErrorType(ErrorCategory.valueOf((String)this.getStringField(hit, "errorType")).ordinal());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName(TITLEID);
        titleId.addValue(this.getStringField(hit, TITLEID));
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName(TITLEBRIEF);
        titleBrief.addValue(this.getStringField(hit, TITLEBRIEF));
        result.addVariable(titleBrief);
        String selectorKey = this.getStringField(hit, INGEST_TEMPLATE);
        if (selectorKey != null && !selectorKey.isEmpty()) {
            WFVariable ingestTemplate = new WFVariable();
            ingestTemplate.setName(INGEST_TEMPLATE);
            ingestTemplate.addValue(selectorKey);
            result.addVariable(ingestTemplate);
        }
        WFVariable isActive = new WFVariable();
        isActive.setName("isActive");
        String isActiveStr = this.getStringField(hit, "isActive");
        isActive.addValue(isActiveStr);
        result.addVariable(isActive);
        result.setIsActive(isActiveStr);
        try {
            Date licenseStartDate = this.getDateField(hit, LICENSESTART);
            if (licenseStartDate != null) {
                String licenseStartStr = displayDateFormat.format(this.getDateField(hit, LICENSESTART));
                WFVariable licenseStart = new WFVariable();
                licenseStart.setName(LICENSESTART);
                licenseStart.addValue(licenseStartStr);
                result.addVariable(licenseStart);
                WFVariable licenseStart1 = new WFVariable();
                licenseStart1.setName(LICENSING_WINDOW_START);
                licenseStart1.addValue(licenseStartStr);
                result.addVariable(licenseStart1);
                WFVariable licenseStart2 = new WFVariable();
                licenseStart2.setName(LICENSE_START);
                licenseStart2.addValue(licenseStartStr);
                result.addVariable(licenseStart2);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not parse license start date", (Throwable)e);
        }
        try {
            Date licenseEndDate = this.getDateField(hit, LICENSEEND);
            if (licenseEndDate != null) {
                String licenseEndStr = displayDateFormat.format(this.getDateField(hit, LICENSEEND));
                WFVariable licenseEnd = new WFVariable();
                licenseEnd.setName(LICENSEEND);
                licenseEnd.addValue(licenseEndStr);
                result.addVariable(licenseEnd);
                WFVariable licenseEnd1 = new WFVariable();
                licenseEnd1.setName(LICENSING_WINDOW_END);
                licenseEnd1.addValue(licenseEndStr);
                result.addVariable(licenseEnd1);
                WFVariable licenseEnd2 = new WFVariable();
                licenseEnd2.setName(LICENSE_END);
                licenseEnd2.addValue(licenseEndStr);
                result.addVariable(licenseEnd2);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not parse license end date", (Throwable)e);
        }
        WFVariable providerId = new WFVariable();
        providerId.setName(PROVIDERID);
        providerId.addValue(this.getStringField(hit, PROVIDERID));
        result.addVariable(providerId);
        if (this.getBooleanField(hit, "hasChildren")) {
            result.addChild(new WFSearchResult());
            while (result.getToken().getAllChildren().size() <= 1) {
                result.getToken().addChild(new WFToken());
            }
        }
        result.setProcessDefinitionName(this.getStringField(hit, "templateName"));
        result.setSearchResultCount(totalCount);
        this.setNodeName(result.getProcessDefinitionName(), result.getToken());
        return result;
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateLoaderService templateLoaderService = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        WorkflowTemplate template = templateLoaderService.getTemplateByFullName(templateName);
        if (template != null) {
            template.breadthFirstTraversal(new NodeVisitor(){

                public void visit(Node node) {
                    Node currentNode;
                    if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                        token.setNodeName(node.getName());
                    }
                }
            });
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Singleton class does not allow cloning!");
    }
}

