/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.util;

import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.util.ResourceConnectionTypeValidator;
import java.util.List;
import java.util.Set;

public final class ResourceValidator {
    private ResourceValidator() {
    }

    public static void validateResource(Resource resource) throws ValidationException {
        ValidationException ve = new ValidationException();
        if (resource == null) {
            ve.addErrorCode("VR-100");
            throw ve;
        }
        ResourceValidator.validateResourceType(resource, ve.getErrorCodes());
        ResourceValidator.validateResourceGroups(resource, ve.getErrorCodes());
        ResourceValidator.validateName(resource, ve.getErrorCodes());
        ResourceValidator.validateConnectionString(resource, ve.getErrorCodes());
        ResourceValidator.validateHeartBeatProperties(resource, ve.getErrorCodes());
        ResourceValidator.validateMaxConcurrentUsers(resource, ve.getErrorCodes());
        ResourceValidator.validateAdministrationState(resource, ve.getErrorCodes());
        if (ve.getErrorCodes().size() > 0) {
            throw ve;
        }
    }

    private static void validateName(Resource resource, List<String> errorList) {
        String name = resource.getName();
        if (name != null) {
            name = name.trim();
            resource.setName(name);
        }
        if (name == null || name.length() == 0) {
            errorList.add("VR-106");
        }
    }

    private static void validateResourceType(Resource resource, List<String> errorList) {
        ResourceType resourceType = resource.getResourceType();
        if (resourceType == null) {
            errorList.add("VR-101");
        }
    }

    private static void validateConnectionString(Resource resource, List<String> errorList) {
        String connectionString = resource.getConnectionString();
        ResourceType type = resource.getResourceType();
        ResourceConnectionType connectionType = type.getConnectionType();
        if (connectionString != null) {
            connectionString = connectionString.trim();
            resource.setConnectionString(connectionString);
        }
        if (connectionString == null || connectionString.length() == 0) {
            errorList.add("VR-102");
            return;
        }
        boolean isValid = ResourceConnectionTypeValidator.validateConnectionString(connectionString, connectionType);
        if (!isValid) {
            errorList.add("VR-103");
        }
    }

    private static void validateResourceGroups(Resource resource, List<String> errorList) {
        Set<ResourceGroup> groups = resource.getResourceGroups();
        if (groups == null || groups.size() <= 0) {
            errorList.add("VR-104");
            return;
        }
        if (resource.getResourceType() != null) {
            ResourceType resourceType = resource.getResourceType();
            for (ResourceGroup group : groups) {
                if (resourceType.equals(group.getResourceType())) continue;
                errorList.add("VR-105");
                break;
            }
        }
        String functionalType = ResourceValidator.standardizeFunctionalType(resource.getFunctionalType());
        for (ResourceGroup group : groups) {
            String groupFunctionalType = ResourceValidator.standardizeFunctionalType(group.getFunctionalType());
            if (functionalType.equals(groupFunctionalType)) continue;
            errorList.add("VR-112");
            break;
        }
        int masterProtectionKeyId = groups.iterator().next().getProtectionKeyId();
        for (ResourceGroup group : groups) {
            if (masterProtectionKeyId == group.getProtectionKeyId()) continue;
            errorList.add("VR-113");
            break;
        }
    }

    private static String standardizeFunctionalType(String functionalTypeValue) {
        String standardizedValue = "";
        if (functionalTypeValue != null && functionalTypeValue.trim().length() > 0) {
            standardizedValue = functionalTypeValue;
        }
        return standardizedValue;
    }

    private static void validateHeartBeatProperties(Resource resource, List<String> errorList) {
        ResourceType type = resource.getResourceType();
        String hbConnectionString = resource.getHeartbeatConnectionString();
        ResourceConnectionType connectionType = type.getHeartbeatConnectionType();
        Long frequency = resource.getHeartbeatFrequency();
        if (type.getHeartbeatConnectionType() == null) {
            resource.setHeartbeatFrequency(null);
            resource.setHeartbeatConnectionString(null);
            return;
        }
        if (hbConnectionString != null) {
            hbConnectionString = hbConnectionString.trim();
            resource.setHeartbeatConnectionString(hbConnectionString);
        }
        if (hbConnectionString == null || hbConnectionString.trim().length() == 0) {
            errorList.add("VR-107");
        } else {
            boolean isValid = ResourceConnectionTypeValidator.validateConnectionString(hbConnectionString, connectionType);
            if (!isValid) {
                errorList.add("VR-108");
            }
        }
        if (frequency == null || frequency < 1L) {
            errorList.add("VR-109");
        }
    }

    private static void validateMaxConcurrentUsers(Resource resource, List<String> errorList) {
        int maxConcurrentUsers = resource.getMaxConcurrentUsers();
        if (maxConcurrentUsers < 0) {
            errorList.add("VR-110");
        }
    }

    private static void validateAdministrationState(Resource resource, List<String> errorList) {
        ResourceState adminState = resource.getAdministrationState();
        if (adminState != ResourceState.ONLINE && adminState != ResourceState.OFFLINE) {
            errorList.add("VR-111");
        }
    }
}

