/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.IResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.IResourceService;
import com.tandbergtv.workflow.resourcemanager.IResourceTypeService;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementInternal;
import com.tandbergtv.workflow.resourcemanager.internal.activator.ResourceManagementActivator;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.internal.lifecycle.LifeCycleManager;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class ResourceManager
implements IResourceManagementInternal {
    private static Logger logger = Logger.getLogger(ResourceManager.class);
    private static final String COLLEAGUE_NAME = "ResourceManager";
    private final Map<String, Object> serviceProperties = new HashMap<String, Object>();
    private ServiceRegistry registry;
    private boolean started = false;

    public ResourceManager(SessionFactory sessionFactory, int systemResourceLimit, int humanResourceLimit) {
        this.serviceProperties.put("SystemResourceLimit", new Integer(systemResourceLimit));
        this.serviceProperties.put("HumanResourceLimit", new Integer(humanResourceLimit));
        this.serviceProperties.put("SessionFactory", sessionFactory);
    }

    public String getServiceName() {
        return COLLEAGUE_NAME;
    }

    public void start() {
        try {
            this.getMediator().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
            this.registry = ServiceRegistry.createRegistry();
            new ResourceManagementActivator(this, this.serviceProperties, this.registry).start();
            this.getMediator().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
            this.setStarted(true);
            logger.info((Object)"The resource management service has started.");
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Resource manager failed to start.", e);
        }
    }

    public void stop() {
        this.setStarted(false);
        this.getMediator().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        new ResourceManagementActivator(this, this.serviceProperties, this.registry).stop();
        this.registry = null;
        this.getMediator().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        logger.info((Object)"The resource management service has stopped.");
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public List<ResourceType> getAllResourceTypes() {
        return this.getResourceTypeService().getAllResourceTypes();
    }

    @Override
    public ResourceType getResourceType(long resourceTypeId) throws FinderException {
        return this.getResourceTypeService().getResourceType(resourceTypeId);
    }

    @Override
    public ResourceType getResourceTypeBySystemId(String systemId) {
        return this.getResourceTypeService().getResourceTypeBySystemId(systemId);
    }

    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        return this.getResourceGroupService().getAllResourceGroups();
    }

    @Override
    public List<ResourceGroup> getVisibleResourceGroups() {
        return this.getResourceGroupService().getVisibleResourceGroups();
    }

    @Override
    public ResourceGroup getResourceGroup(long resourceGroupId) throws FinderException {
        return this.getResourceGroupService().getResourceGroup(resourceGroupId);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        return this.getResourceGroupService().getResourceGroupsByResourceType(resourceTypeId);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResource(long resourceId) {
        return this.getResourceGroupService().getResourceGroupsByResource(resourceId);
    }

    @Override
    public ResourceGroup getResourceGroupByToken(long tokenId) {
        return this.getResourceGroupService().getResourceGroupByToken(tokenId);
    }

    @Override
    public List<ResourceGroup> getExternallyAcquiredResourceGroupsByUser(String userName) {
        return this.getResourceGroupService().getExternallyAcquiredResourceGroupsByUser(userName);
    }

    @Override
    public boolean isExternallyAcquiredResourceGroup(long resourceGroupId) throws FinderException {
        return this.getResourceGroupService().isExternallyAcquiredResourceGroup(resourceGroupId);
    }

    @Override
    public ResourceGroup moveQueueItemToTop(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        return this.getResourceGroupService().moveQueueItemToTop(resourceGroupId, queueItemId);
    }

    @Override
    public ResourceGroup moveQueueItemToBottom(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        return this.getResourceGroupService().moveQueueItemToBottom(resourceGroupId, queueItemId);
    }

    @Override
    public ResourceGroup moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        return this.getResourceGroupService().moveQueueItemUp(resourceGroupId, queueItemId, neighborQueueItemId);
    }

    @Override
    public ResourceGroup moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        return this.getResourceGroupService().moveQueueItemDown(resourceGroupId, queueItemId, neighborQueueItemId);
    }

    @Override
    public ResourceGroup setResourceGroupQueueUIVisibility(long resourceGroupId, boolean visible) throws FinderException, DataOperationException {
        return this.getResourceGroupService().setResourceGroupQueueUIVisibility(resourceGroupId, visible);
    }

    @Override
    public List<Resource> getAllResources() {
        return this.getResourceService().getAllResources();
    }

    @Override
    public List<Resource> getResourcesBySearchCriteria(SearchCriteria searchCriteria) throws DataOperationException {
        return this.getResourceService().getResourcesBySearchCriteria(searchCriteria);
    }

    @Override
    public int getActiveResourcesCount() {
        return this.getResourceService().getActiveResourcesCount();
    }

    @Override
    public Resource getResource(long resourceId) throws FinderException, DataOperationException {
        return this.getResourceService().getResource(resourceId);
    }

    @Override
    public List<Resource> getResourcesByGroup(long resourceGroupId) {
        return this.getResourceService().getResourcesByGroup(resourceGroupId);
    }

    @Override
    public List<Resource> getResourcesByResourceType(long resourceTypeId) {
        return this.getResourceService().getResourcesByResourceType(resourceTypeId);
    }

    @Override
    public List<Resource> getResourcesBySystemId(String systemId) {
        return this.getResourceService().getResourcesBySystemId(systemId);
    }

    @Override
    public Resource getResourceByToken(long tokenId) {
        return this.getResourceService().getResourceByToken(tokenId);
    }

    @Override
    public Resource getResourceByUser(String userName) {
        return this.getResourceService().getResourceByUser(userName);
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString) {
        return this.getResourceService().getResourceByConnectionString(connectionString);
    }

    @Override
    public Resource getResourceByConnectionString(String connectionString, long groupId) {
        return this.getResourceService().getResourceByConnectionString(connectionString, groupId);
    }

    @Override
    public Resource setResourceOnline(long resourceId) throws FinderException, DataOperationException {
        return this.getResourceService().setResourceOnline(resourceId);
    }

    @Override
    public Resource setResourceOffline(long resourceId) throws FinderException, DataOperationException {
        return this.getResourceService().setResourceOffline(resourceId);
    }

    @Override
    public Resource createResource(Resource resource) throws ValidationException, DataOperationException {
        return this.getResourceService().createResource(resource);
    }

    @Override
    public Resource updateResource(Resource resource) throws ValidationException, ActionException, FinderException, DataOperationException {
        return this.getResourceService().updateResource(resource);
    }

    @Override
    public boolean deleteResource(long resourceId) throws ActionException, DataOperationException {
        return this.getResourceService().deleteResource(resourceId);
    }

    @Override
    public boolean isResourceActive(long resourceId) {
        return this.getResourceService().isResourceActive(resourceId);
    }

    @Override
    public IAllocationKeyService getAllocationKeyService() {
        return this.getResourceService().getAllocationKeyService();
    }

    @Override
    public ComponentHealthStatus getHealthStatus() {
        return this.getResourceService().getHealthStatus();
    }

    public String getColleagueName() {
        return this.getServiceName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        this.getDistributedEventHandler().handleEvent(event);
    }

    @Override
    public boolean isDistributedCacheInitialized() {
        LifeCycleManager manager;
        ServiceRegistry registry = this.getLocalRegistry();
        if (registry != null && (manager = (LifeCycleManager)registry.lookup(LifeCycleManager.class)) != null) {
            return manager.isDistributedCacheInitialized();
        }
        return false;
    }

    @Override
    public ServiceRegistry getLocalRegistry() {
        return this.registry;
    }

    private IMediator getMediator() {
        return DefaultMediator.getInstance();
    }

    private IResourceTypeService getResourceTypeService() {
        return (IResourceTypeService)this.getService("DistributedResourceTypeService");
    }

    private IResourceGroupService getResourceGroupService() {
        return (IResourceGroupService)this.getService("DistributedResourceGroupService");
    }

    private IResourceService getResourceService() {
        return (IResourceService)this.getService("DistributedResourceService");
    }

    private IEventHandler getDistributedEventHandler() {
        return (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
    }

    private <T extends Service> T getService(String name) {
        return (T)this.getLocalRegistry().lookup(name);
    }
}

