/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class ResourceHeartBeatEventLogger {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH-mm-ss";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PRODUCT_DIR_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String BASE_RESOURCE_HISTORY_DIR = "workflow" + File.separator + "history" + File.separator + "resources";
    private static final String EVENT_TIME_SEPARATOR = "@";
    private static final String FILE_EXT = ".json";
    private static final Logger logger = Logger.getLogger(ResourceHeartBeatEventLogger.class);

    public void logEvent(ResourceHeartBeatEvent event) {
        Calendar cal = Calendar.getInstance();
        String resourceId = Long.toString(event.getParentResource().getId());
        String resourceHistoryDir = this.getResourceHistoryIdPath(resourceId, cal.getTime());
        File resourceHistoryFolder = new File(resourceHistoryDir);
        if (!resourceHistoryFolder.exists() && !resourceHistoryFolder.mkdirs()) {
            logger.error((Object)("Unable to create history the logging directory for resource " + resourceId));
            return;
        }
        Writer writer = null;
        try {
            try {
                String filePath = resourceHistoryFolder + File.separator + this.getFileName(event, cal.getTime());
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "utf-8"));
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("date", this.getSimpleDateFormatter(TIMESTAMP_FORMAT).format(cal.getTime()));
                valueMap.put("eventType", event.getClass().getName());
                valueMap.put("resourceId", resourceId);
                valueMap.put("resourceStatus", event.getParentResource().getOperationalState().toString());
                valueMap.put("message", event.getMessage());
                ObjectMapper mapper = new ObjectMapper();
                mapper.writeValue(writer, valueMap);
            }
            catch (IOException ex) {
                logger.error((Object)"An error occurred while logging the ResourceHeartBeatEvent", (Throwable)ex);
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"An error occurred while logging the ResourceHeartBeatEvent", (Throwable)e);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)"An error occurred while logging the ResourceHeartBeatEvent", (Throwable)e);
            }
        }
    }

    public String getBaseResourceHistoryPath() {
        return System.getProperty(PRODUCT_DIR_PROPERTY) + File.separator + BASE_RESOURCE_HISTORY_DIR;
    }

    public String getResourceHistoryDatePath(Date date) {
        return this.getBaseResourceHistoryPath() + File.separator + this.getSimpleDateFormatter(DATE_FORMAT).format(date);
    }

    public String getResourceHistoryIdPath(String resourceId, Date date) {
        return this.getResourceHistoryDatePath(date) + File.separator + resourceId;
    }

    private String getFileName(ResourceHeartBeatEvent event, Date date) {
        return event.getClass().getSimpleName() + EVENT_TIME_SEPARATOR + this.getSimpleDateFormatter(TIME_FORMAT).format(date) + FILE_EXT;
    }

    public SimpleDateFormat getSimpleDateFormatter(String format) {
        return new SimpleDateFormat(format);
    }
}

