/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.event;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ITaskCompletionListener;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.resourcemanager.internal.event.HandleEventCallable;
import com.tandbergtv.workflow.resourcemanager.internal.event.ILocalEventScheduler;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class LocalEventScheduler
extends Scheduler<Void>
implements ILocalEventScheduler {
    private final List<ITaskCompletionListener> listeners = new CopyOnWriteArrayList<ITaskCompletionListener>();

    public LocalEventScheduler(int size, int max) {
        super("resource-localEvents", size, max);
    }

    @Override
    public Future<Void> schedule(HandleEventCallable callable) {
        LocalHandleEventCallableFuture result = new LocalHandleEventCallableFuture(callable);
        this.getExecutor().execute(result);
        return result;
    }

    @Override
    public void addTaskCompletionListener(ITaskCompletionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTaskCompletionListener(ITaskCompletionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setRegistry(ServiceRegistry registry) {
    }

    private final class LocalHandleEventCallableFuture
    extends FutureTask<Void> {
        private final HandleEventCallable callable;

        public LocalHandleEventCallableFuture(HandleEventCallable callable) {
            super(callable);
            this.callable = callable;
        }

        @Override
        protected void done() {
            super.done();
            if (this.callable.getEventKey().getQueueId() != null) {
                for (ITaskCompletionListener listener : LocalEventScheduler.this.listeners) {
                    try {
                        listener.onTaskCompleted((Callable)this.callable, (Future)this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

