/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.callable;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementNotReadyException;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementInternal;
import java.io.Serializable;
import java.util.concurrent.Callable;

public abstract class ResourceManagementCallable<V>
implements Callable<V>,
Serializable {
    private static final long serialVersionUID = -8973305533391693093L;
    private static final long TIMEOUT = 10000L;
    private static final int RETRY_COUNT = 5;

    @Override
    public V call() throws Exception {
        int count = 0;
        while (!this.isResourceManagerStarted() && count < 5) {
            Thread.sleep(10000L);
            ++count;
        }
        if (!this.isResourceManagerStarted()) {
            String msg = "The Resource Management Service is not ready.";
            throw new ResourceManagementNotReadyException(msg);
        }
        return this.performTask();
    }

    protected abstract V performTask() throws Exception;

    protected ResourceManagement getResourceManagementService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (ResourceManagement)registry.lookup(ResourceManagement.class);
    }

    protected ServiceRegistry getInternalRegistry() {
        return ((IResourceManagementInternal)this.getResourceManagementService()).getLocalRegistry();
    }

    protected <T extends Service> T getService(Class<T> clazz) {
        return (T)((Service)this.getInternalRegistry().lookup(clazz));
    }

    protected <T extends Service> T getService(String name) {
        return (T)this.getInternalRegistry().lookup(name);
    }

    private boolean isResourceManagerStarted() {
        ResourceManagement manager = this.getResourceManagementService();
        return manager != null && manager.isStarted();
    }
}

