/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcegroup;

import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.resourcemanager.IResourceGroupService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.callable.ResourceManagementCallable;

public abstract class ResourceGroupServiceCallable<V>
extends ResourceManagementCallable<V>
implements DistributedCallable<V> {
    private static final long serialVersionUID = 394114387711038766L;
    private Long resourceTypeId;

    protected ResourceGroupServiceCallable() {
    }

    protected ResourceGroupServiceCallable(Long resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }

    public Long getKey() {
        return this.getResourceTypeId();
    }

    public Long getResourceTypeId() {
        return this.resourceTypeId;
    }

    @Override
    protected V performTask() throws Exception {
        IResourceTypeIdAware service = null;
        if (IResourceTypeIdAware.class.isInstance(this.getService())) {
            service = (IResourceTypeIdAware)IResourceTypeIdAware.class.cast(this.getService());
        }
        if (service != null) {
            service.setResourceTypeIdForRequest(this.getResourceTypeId());
        }
        try {
            V v = this.performServiceTask();
            return v;
        }
        finally {
            if (service != null) {
                service.removeResourceTypeIdForRequest();
            }
        }
    }

    protected abstract V performServiceTask() throws Exception;

    protected IResourceGroupService getService() {
        return (IResourceGroupService)this.getService("LocalResourceGroupService");
    }
}

