/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.allocation;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.LocalCacheNotReadyException;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueue;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroupQueueItem;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.allocation.IResourceAllocationService;
import com.tandbergtv.workflow.resourcemanager.internal.container.IContainerService;
import com.tandbergtv.workflow.resourcemanager.internal.resource.LocalResourceService;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.IKeyBasedAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.ResourceAllocationStrategy;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public final class ResourceAllocationService
extends ResourceManagementService
implements IResourceAllocationService {
    private static final Logger logger = Logger.getLogger(ResourceAllocationService.class);

    @Override
    public boolean requestResourceAllocation(long resourceGroupId, ResourceConsumerKey key, Set<ProtectionKey> protectionKeys) {
        boolean accepted = false;
        long start = System.currentTimeMillis();
        String groupName = null;
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady("resource group[" + resourceGroupId + "]", container);
        boolean isValid = false;
        boolean queueDisabled = false;
        container.getReadLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            int protectionKeyId = resourceGroup.getProtectionKeyId();
            boolean bl = isValid = protectionKeyId == -1;
            if (protectionKeys != null && !isValid) {
                for (ProtectionKey protectionKey : protectionKeys) {
                    if (protectionKey.getId() != resourceGroup.getProtectionKeyId()) continue;
                    isValid = true;
                    break;
                }
            }
            queueDisabled = resourceGroup.isConsumerTracingDisabled();
            if (isValid && queueDisabled) {
                groupName = container.toString();
                ResourceGroupQueueItem queueItem = new ResourceGroupQueueItem(key);
                Long resourceId = this.getResourceForAllocation(container, null, queueItem);
                if (resourceId != null) {
                    accepted = this.allocateResource(resourceId, container, queueItem, false, null);
                }
            }
        }
        finally {
            container.getReadLock().unlock();
        }
        if (!isValid) {
            logger.warn((Object)(key + " and mapped " + container + " have different protection keys."));
            this.getMediator().send((WorkflowEvent)new ResourceRequestRejectedEvent(key));
            accepted = false;
        } else if (!queueDisabled) {
            ResourceGroupQueueItem queueItem = new ResourceGroupQueueItem(key);
            accepted = this.queueToken(resourceGroupId, queueItem);
        } else if (queueDisabled && !accepted) {
            logger.warn((Object)(key + " cannot be allocated an available resource. " + "Queueing disabled for " + groupName + ", rejecting request."));
            this.getMediator().send((WorkflowEvent)new ResourceRequestRejectedEvent(key));
        }
        long duration = System.currentTimeMillis() - start;
        logger.debug((Object)(key + " request for resource allocation completed in ~" + duration + " ms."));
        return accepted;
    }

    @Override
    public boolean dequeueToken(long resourceGroupId, Token token) {
        if (this.isConsumerTracingDisabled(resourceGroupId)) {
            return false;
        }
        long start = this.getStartTime();
        int size = -1;
        boolean result = false;
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            ResourceGroupQueueItem queueItem = this.dequeueItem(resourceGroup, token.getId());
            if (queueItem != null) {
                result = true;
                container.updateEntity();
                this.sendQueueUsageEvent(queueItem, token);
            }
            size = ((ResourceGroup)container.getEntity()).getQueue().size();
            if (result) {
                long duration = this.getDuration(start);
                logger.info((Object)(queueItem.getResourceConsumerKey() + " removed from " + container + " in ~" + duration + " msec, " + size + " items."));
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        return result;
    }

    @Override
    public boolean repositionQueuedToken(long resourceGroupId, long tokenId, ProcessPriority newPriority) {
        if (this.isConsumerTracingDisabled(resourceGroupId)) {
            return false;
        }
        long start = this.getStartTime();
        int size = -1;
        boolean result = false;
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            ResourceGroupQueueItem queueItem = this.dequeueItem(resourceGroup, tokenId);
            if (queueItem != null) {
                queueItem.setPriority(newPriority);
                queueItem.setQueueOrderDate(queueItem.getQueuedDate());
                result = this.enqueueItem(resourceGroup, queueItem);
                container.updateEntity();
            }
            size = ((ResourceGroup)container.getEntity()).getQueue().size();
            if (result) {
                long duration = this.getDuration(start);
                logger.info((Object)(queueItem.getResourceConsumerKey() + " repositioned in " + container + " in ~" + duration + " msec, " + size + " items."));
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        return result;
    }

    @Override
    public boolean moveQueueItemToTop(long resourceGroupId, long queueItemId) {
        return this.moveQueueItemToEnd(resourceGroupId, queueItemId, true);
    }

    @Override
    public boolean moveQueueItemToBottom(long resourceGroupId, long queueItemId) {
        return this.moveQueueItemToEnd(resourceGroupId, queueItemId, false);
    }

    @Override
    public boolean moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) {
        return this.moveQueueItem(resourceGroupId, queueItemId, neighborQueueItemId, true);
    }

    @Override
    public boolean moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) {
        return this.moveQueueItem(resourceGroupId, queueItemId, neighborQueueItemId, false);
    }

    private boolean isConsumerTracingDisabled(long resourceGroupId) {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady("resource group[" + resourceGroupId + "]", container);
        container.getReadLock().lock();
        try {
            boolean bl = ((ResourceGroup)container.getEntity()).isConsumerTracingDisabled();
            return bl;
        }
        finally {
            container.getReadLock().unlock();
        }
    }

    private boolean queueToken(long resourceGroupId, ResourceGroupQueueItem queueItem) {
        long start = this.getStartTime();
        int size = -1;
        boolean result = false;
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            result = this.enqueueItem(resourceGroup, queueItem);
            if (result) {
                container.updateEntity();
            }
            size = ((ResourceGroup)container.getEntity()).getQueue().size();
        }
        finally {
            container.getWriteLock().unlock();
        }
        if (result) {
            long duration = this.getDuration(start);
            logger.info((Object)(queueItem.getResourceConsumerKey() + " added to " + container + " in ~" + duration + " msec, " + size + " items."));
        }
        return result;
    }

    private boolean enqueueItem(ResourceGroup resourceGroup, ResourceGroupQueueItem queueItem) {
        ResourceGroupQueue queue = resourceGroup.getQueue();
        ResourceGroupQueueItem oldItem = queue.findItem(queueItem.getTokenId());
        ResourceConsumerKey key = queueItem.getResourceConsumerKey();
        if (oldItem != null) {
            logger.error((Object)(key + " is already queued for resource group" + resourceGroup + ", and cannot be enqueued again."));
            return false;
        }
        int size = queue.size();
        logger.debug((Object)(key + ", adding to queue for resource group" + resourceGroup + " of size " + size));
        long current = this.getStartTime();
        int index = queue.add(queueItem);
        long diff = this.getDuration(current);
        logger.debug((Object)(key + ", added to queue for resource group" + resourceGroup + " at index " + index + " in " + diff + " msec"));
        long resourceGroupId = resourceGroup.getId();
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        container.notifyQueue();
        return true;
    }

    private ResourceGroupQueueItem dequeueItem(ResourceGroup resourceGroup, long tokenId) {
        ResourceGroupQueueItem result = null;
        ResourceGroupQueue queue = resourceGroup.getQueue();
        result = queue.findItem(tokenId);
        if (result != null && queue.remove(result)) {
            logger.debug((Object)("Queue Item for " + result.getResourceConsumerKey() + " removed from " + "queue for resource group" + resourceGroup));
        }
        return result;
    }

    private boolean moveQueueItemToEnd(long resourceGroupId, long queueItemId, boolean moveTop) {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            ResourceGroupQueue queue = resourceGroup.getQueue();
            int itemIndex = queue.indexOf(new ResourceGroupQueueItem(queueItemId));
            if (itemIndex == -1) {
                return false;
            }
            int size = queue.size();
            if (moveTop && itemIndex == 0 || !moveTop && itemIndex == size - 1) {
                return true;
            }
            if (size > 1) {
                ResourceGroupQueueItem queueItem = queue.get(itemIndex);
                queue.remove(queueItem);
                int index = moveTop ? 0 : queue.size() - 1;
                ResourceGroupQueueItem endQueueItem = queue.get(index);
                this.copyPriority(endQueueItem, queueItem);
                if (!moveTop) {
                    ++index;
                }
                queue.add(index, queueItem);
                container.updateEntity();
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        return true;
    }

    private boolean moveQueueItem(long resourceGroupId, long queueItemId, long neighborQueueItemId, boolean moveUp) {
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
            ResourceGroupQueue queue = resourceGroup.getQueue();
            int itemIndex = queue.indexOf(new ResourceGroupQueueItem(queueItemId));
            if (itemIndex == -1) {
                return false;
            }
            int neighborIndex = queue.indexOf(new ResourceGroupQueueItem(neighborQueueItemId));
            if (neighborIndex != -1) {
                if (itemIndex < neighborIndex && moveUp) {
                    String msg = "Cannot move item above neighbor since the item is already above the neighbor.";
                    throw new IllegalArgumentException(msg);
                }
                if (itemIndex > neighborIndex && !moveUp) {
                    String msg = "Cannot move item below neighbor since the item is already below the neighbor.";
                    throw new IllegalArgumentException(msg);
                }
                ResourceGroupQueueItem queueItem = queue.findItemByKey(queueItemId);
                ResourceGroupQueueItem neighbour = queue.findItemByKey(neighborQueueItemId);
                queue.remove(queueItem);
                this.copyPriority(neighbour, queueItem);
                int index = queue.indexOf(neighbour) + (moveUp ? 0 : 1);
                queue.add(index, queueItem);
                container.updateEntity();
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        return true;
    }

    private void copyPriority(ResourceGroupQueueItem source, ResourceGroupQueueItem target) {
        target.setPriority(source.getPriority());
        target.setQueueOrderDate(source.getQueueOrderDate());
        this.getMediator().sendAsync((WorkflowEvent)new QueueOrderChangedEvent(target.getResourceConsumerKey(), source.getPriority()));
    }

    @Override
    public boolean performInternalAllocation(long resourceGroupId) {
        return this.performAllocation(resourceGroupId, null, -1L, null);
    }

    @Override
    public boolean performExternalAllocation(ResourceConsumerKey key, String connectionString, String taskAssigner) {
        if (connectionString == null) {
            String msg = "Received an external allocation request for " + key + ") with an invalid(null) resource connection string.";
            throw new IllegalArgumentException(msg);
        }
        return this.performAllocation(key.getResourceGroupId(), connectionString, key.getId(), taskAssigner);
    }

    @Override
    public boolean releaseToken(Token token, ResourceConsumerKey key) {
        if (this.isConsumerTracingDisabled(key.getResourceGroupId())) {
            return false;
        }
        long start = this.getStartTime();
        ResourceContainer container = this.getResourceContainerByTokenId(key.getId());
        if (container == null) {
            return false;
        }
        container.getWriteLock().lock();
        try {
            ResourceUser userToRelease = this.removeResourceUser(container, key.getId());
            if (userToRelease == null) {
                return false;
            }
            Resource resource = (Resource)container.getEntity();
            this.sendResourceUsageEvent(resource, userToRelease, token, key.getId());
            this.updateResourceContainer(container);
            long duration = this.getDuration(start);
            logger.info((Object)(key + " released " + container + " in ~" + duration + " msec, " + resource.getUserCount() + " users."));
        }
        finally {
            container.getWriteLock().unlock();
        }
        this.notifyQueues(((Resource)container.getEntity()).getId());
        return true;
    }

    @Override
    public boolean releaseToken(long resourceGroupId, long tokenId) {
        if (this.isConsumerTracingDisabled(resourceGroupId)) {
            return false;
        }
        long start = this.getStartTime();
        ResourceContainer container = this.getResourceContainerByTokenId(tokenId);
        if (container == null) {
            return false;
        }
        container.getWriteLock().lock();
        try {
            ResourceUser userToRelease = this.removeResourceUser(container, tokenId);
            if (userToRelease == null) {
                return false;
            }
            this.updateResourceContainer(container);
            long duration = this.getDuration(start);
            logger.info((Object)("tokenId [" + tokenId + "]" + " released " + container + " in ~" + duration + " msec, " + ((Resource)container.getEntity()).getUserCount() + " users."));
        }
        finally {
            container.getWriteLock().unlock();
        }
        this.notifyQueues(((Resource)container.getEntity()).getId());
        return true;
    }

    @Override
    public void notifyQueues(long resourceId) {
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (container == null) {
            return;
        }
        container.getReadLock().lock();
        try {
            if (!container.isStopped()) {
                container.notifyResourceGroups();
            }
        }
        finally {
            container.getReadLock().unlock();
        }
    }

    private ResourceContainer getResourceContainerByTokenId(long tokenId) {
        Resource resource;
        ResourceContainer container = this.getLocatorService().findResource(tokenId);
        if (container == null && (resource = this.getManager().getResourceByToken(tokenId)) != null) {
            String msg = "resource" + resource + " is not present in local cache.";
            throw new LocalCacheNotReadyException(msg);
        }
        return container;
    }

    private ResourceUser removeResourceUser(ResourceContainer container, long tokenId) {
        this.getContainerService().verifyContainerReady(container);
        Resource resource = (Resource)container.getEntity();
        ResourceUser userToRelease = null;
        for (ResourceUser user : resource.getUsers()) {
            if (user.getId() != tokenId) continue;
            userToRelease = user;
            break;
        }
        if (userToRelease == null) {
            logger.debug((Object)("Attempting to release " + tokenId + ", but token is not using a resource."));
            return userToRelease;
        }
        resource.removeUser(userToRelease);
        return userToRelease;
    }

    private void updateResourceContainer(ResourceContainer container) {
        boolean stateChanged = this.getStateManager().tryTakeResourceOffline(container);
        if (stateChanged) {
            container.updateEntity(true);
        } else {
            container.updateEntity();
        }
    }

    private boolean performAllocation(long resourceGroupId, String connectionString, long tokenId, String taskAssigner) {
        boolean resourceAllocated = false;
        ResourceGroupContainer container = (ResourceGroupContainer)this.getResourceGroupContainerCache().get((Serializable)Long.valueOf(resourceGroupId));
        this.getContainerService().verifyContainerReady(this.getGroupName(resourceGroupId), container);
        container.getWriteLock().lock();
        try {
            boolean internalAllocation;
            this.getContainerService().verifyContainerReady(container);
            ResourceGroup group = (ResourceGroup)container.getEntity();
            boolean bl = internalAllocation = connectionString == null;
            if (internalAllocation != group.isInternallyAcquired()) {
                String type = group.isInternallyAcquired() ? "internal" : "external";
                String otherType = internalAllocation ? "internal" : "external";
                String msg = container + " performs " + type + " allocation, cannot attempt " + otherType + " allocation.";
                throw new IllegalArgumentException(msg);
            }
            ResourceAllocationStrategy strategy = container.getAllocationStrategy();
            boolean keyBasedAllocation = group.isInternallyAcquired() && strategy instanceof IKeyBasedAllocationStrategy;
            ResourceGroupQueueItem queueItem = null;
            boolean allocationCompleted = false;
            Iterator<ResourceGroupQueueItem> iterator = group.getQueue().iterator();
            while (!allocationCompleted) {
                iterator = keyBasedAllocation ? iterator : group.getQueue().iterator();
                queueItem = this.getItemForAllocation(group, tokenId, iterator);
                if (queueItem == null) {
                    return false;
                }
                Long resourceId = this.getResourceForAllocation(container, connectionString, queueItem);
                if (resourceId == null) {
                    return false;
                }
                resourceAllocated = this.allocateResource(resourceId, container, queueItem, taskAssigner);
                if (!resourceAllocated) continue;
                container.updateEntity();
                boolean bl2 = allocationCompleted = keyBasedAllocation || !group.isInternallyAcquired();
            }
        }
        finally {
            container.getWriteLock().unlock();
        }
        return resourceAllocated;
    }

    private ResourceGroupQueueItem getItemForAllocation(ResourceGroup resourceGroup, long tokenId, Iterator<ResourceGroupQueueItem> iterator) {
        ResourceGroupQueueItem queueItemToAllocate = null;
        while (iterator.hasNext()) {
            ResourceGroupQueueItem queueItem = iterator.next();
            if (!resourceGroup.isInternallyAcquired() && queueItem.getTokenId() != tokenId) continue;
            queueItemToAllocate = queueItem;
            break;
        }
        return queueItemToAllocate;
    }

    private Long getResourceForAllocation(ResourceGroupContainer container, String connectionString, ResourceGroupQueueItem queueItem) {
        Long resourceId = null;
        ResourceGroup resourceGroup = (ResourceGroup)container.getEntity();
        if (resourceGroup.getResources().size() == 0) {
            logger.warn((Object)("There are no resources present in " + container));
            return null;
        }
        if (resourceGroup.isInternallyAcquired()) {
            try {
                ResourceAllocationStrategy strategy = container.getAllocationStrategy();
                ResourceGroup clone = this.getCloneService().cloneResourceGroup((ResourceGroup)container.getEntity());
                this.updateResourcesForGroup(clone);
                clone.getQueue().setCurrent(queueItem);
                Resource resource = null;
                if (strategy instanceof IKeyBasedAllocationStrategy) {
                    IKeyBasedAllocationStrategy strategy2 = (IKeyBasedAllocationStrategy)strategy;
                    resource = strategy2.allocateResource(clone, queueItem.getAllocationKey());
                } else {
                    resource = strategy.allocateResource(clone);
                }
                resourceId = resource != null ? Long.valueOf(resource.getId()) : null;
            }
            catch (Exception ex) {
                String msg = "The allocation strategy for " + container + " has failed when attempting to allocate a resource for " + queueItem.getResourceConsumerKey();
                logger.warn((Object)msg, (Throwable)ex);
            }
        } else {
            ICacheService<ResourceContainer> cache = this.getResourceContainerCache();
            for (Serializable key : cache.getKeys()) {
                ResourceContainer resourceContainer = (ResourceContainer)cache.get(key);
                if (resourceContainer == null) continue;
                resourceContainer.getReadLock().lock();
                try {
                    Resource resource = (Resource)resourceContainer.getEntity();
                    if (!resource.getResourceGroups().contains(resourceGroup) || !connectionString.equals(resource.getConnectionString())) continue;
                    Long l = resource.getId();
                    return l;
                }
                finally {
                    resourceContainer.getReadLock().unlock();
                }
            }
        }
        return resourceId;
    }

    private void updateResourcesForGroup(ResourceGroup group) {
        LocalResourceService resourceService = this.getLocalResourceService();
        resourceService.setResourceTypeIdForRequest(group.getResourceType().getId());
        try {
            HashSet<Resource> resources = new HashSet<Resource>();
            for (Resource resource : group.getResources()) {
                try {
                    Resource currentResource = resourceService.getResource(resource.getId());
                    if (currentResource == null) continue;
                    resources.add(currentResource);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            group.setResources(resources);
        }
        finally {
            resourceService.removeResourceTypeIdForRequest();
        }
    }

    private boolean allocateResource(long resourceId, ResourceGroupContainer groupContainer, ResourceGroupQueueItem queueItem, String taskAssigner) {
        return this.allocateResource(resourceId, groupContainer, queueItem, true, taskAssigner);
    }

    private boolean allocateResource(long resourceId, ResourceGroupContainer groupContainer, ResourceGroupQueueItem queueItem, boolean isInQueue, String taskAssigner) {
        ResourceContainer container = (ResourceContainer)this.getResourceContainerCache().get((Serializable)Long.valueOf(resourceId));
        if (isInQueue) {
            if (container == null || container.isStopped()) {
                return false;
            }
        } else {
            String name = "resource[" + resourceId + "]";
            this.getContainerService().verifyContainerReady(name, container);
        }
        Lock containerLock = isInQueue ? container.getWriteLock() : container.getReadLock();
        containerLock.lock();
        try {
            String groupType;
            if (isInQueue) {
                if (container.isStopped()) {
                    return false;
                }
            } else {
                this.getContainerService().verifyContainerReady(container);
            }
            ResourceGroup group = (ResourceGroup)groupContainer.getEntity();
            Resource resource = (Resource)container.getEntity();
            String string = groupType = group.isInternallyAcquired() ? "" : "externally acquired ";
            if (!resource.getResourceGroups().contains(group)) {
                String msg = container + " selected for allocation for " + groupType + groupContainer + ", but resource not in resource group. Ignoring allocation.";
                logger.error((Object)msg);
                return false;
            }
            if (!AllocationUtility.isResourceAvailable(resource)) {
                String msg = container + " selected for allocation for " + groupType + groupContainer + ", but resource is not available for allocation. Ignoring allocation.";
                logger.error((Object)msg);
                return false;
            }
            if (isInQueue) {
                group.getQueue().remove(queueItem);
                ResourceUser user = new ResourceUser(queueItem.getResourceConsumerKey());
                resource.addUser(user);
                container.updateResourceGroupsForNotification(group.getId());
                container.updateEntity();
            }
            Resource clone = this.getCloneService().cloneResource(resource);
            IAllocationKeyService keyService = this.getManager().getAllocationKeyService();
            String allocationKey = keyService.generateAllocationKey(resource);
            ResourceConsumerKey key = queueItem.getResourceConsumerKey();
            key.setAllocationKey(allocationKey);
            ResourceGroupQueueItem cloneItem = (ResourceGroupQueueItem)queueItem.clone();
            ResourceGroup cloneGroup = new ResourceGroup(group.getId());
            cloneItem.setResourceGroup(cloneGroup);
            ResourceAcquiredEvent event = new ResourceAcquiredEvent(cloneItem, clone, taskAssigner);
            this.getMediator().send((WorkflowEvent)event);
            String type = group.isInternallyAcquired() ? "" : "externally acquired ";
            logger.info((Object)(key + " assigned " + type + container + " via " + groupContainer + ", " + resource.getUserCount() + " users"));
        }
        finally {
            containerLock.unlock();
        }
        return true;
    }

    private String getGroupName(long resourceGroupId) {
        return "resource group[" + resourceGroupId + "]";
    }

    private void sendQueueUsageEvent(ResourceGroupQueueItem queueItem, Token token) {
        ResourceGroup clone = new ResourceGroup(queueItem.getResourceGroup().getId());
        Date start = queueItem.getQueuedDate();
        Date end = new Date();
        WorkflowProcessStatusLogEvent event = new WorkflowProcessStatusLogEvent(true, token, clone, null, start, end);
        this.getMediator().send((WorkflowEvent)event);
    }

    private void sendResourceUsageEvent(Resource resource, ResourceUser user, Token token, long tokenId) {
        ResourceGroup group = new ResourceGroup(user.getResourceGroupId());
        Date start = user.getUsageStartDate();
        Date end = new Date();
        WorkflowProcessStatusLogEvent event = new WorkflowProcessStatusLogEvent(false, token, group, new Resource(resource.getId()), start, end);
        this.getMediator().send((WorkflowEvent)event);
    }

    private long getStartTime() {
        return System.currentTimeMillis();
    }

    private long getDuration(long start) {
        return System.currentTimeMillis() - start;
    }

    private ResourceManagement getManager() {
        return (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
    }

    private IMediator getMediator() {
        return DefaultMediator.getInstance();
    }

    private ICacheService<ResourceGroupContainer> getResourceGroupContainerCache() {
        return (ICacheService)this.getService("ResourceGroupContainerCache");
    }

    private ICacheService<ResourceContainer> getResourceContainerCache() {
        return (ICacheService)this.getService("ResourceContainerCache");
    }

    private ResourceStateManager getStateManager() {
        return this.getService(ResourceStateManager.class);
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }

    private ICloneService getCloneService() {
        return this.getService(ICloneService.class);
    }

    private IContainerService getContainerService() {
        return this.getService(IContainerService.class);
    }

    private LocalResourceService getLocalResourceService() {
        return (LocalResourceService)this.getService("LocalResourceService");
    }
}

