/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.tandbergtv.workflow.core.service.cache.CacheService;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import java.io.Serializable;

public abstract class AbstractCompositeCache<T>
extends DistributedCache<T> {
    protected final ICacheService<T> cache;

    protected AbstractCompositeCache(String name, int size) {
        super(name);
        this.cache = new CacheService(name, size);
    }

    @Override
    public void add(Serializable key, T entity) {
        this.cache.add(key, entity);
        super.add(key, entity);
    }

    @Override
    public T get(Serializable key) {
        T entity = this.cache.get(key);
        if (entity == null) {
            entity = super.get(key);
        }
        return entity;
    }

    @Override
    public int count() {
        return this.cache.count();
    }

    @Override
    public void remove(Serializable key) {
        this.cache.remove(key);
        super.remove(key);
    }

    @Override
    public void start() {
        this.cache.start();
        super.start();
    }

    @Override
    public void stop() {
        this.cache.stop();
        super.stop();
    }
}

