/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiTask;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.core.service.thread.DistributedLocalCallable;
import com.tandbergtv.workflow.core.service.thread.DistributedMasterCallable;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;

public class DistributedScheduler<T>
implements ISchedulerService<T> {
    private final String name;
    private final int size;
    private ExecutorService executor;

    public DistributedScheduler(String name) {
        this(name, 1);
    }

    public DistributedScheduler(String name, int size) {
        this.name = name;
        this.size = size;
        ExecutorConfig ec = new ExecutorConfig(name, this.size, this.size, 300);
        Hazelcast.getConfig().addExecutorConfig(ec);
    }

    @Override
    public Future<T> schedule(Callable<T> callable) {
        if (this.executor == null) {
            throw new IllegalStateException("Scheduler " + this.name + " has not started");
        }
        RunnableFuture<T> future = this.newTaskFor(callable);
        this.executor.execute(future);
        return future;
    }

    @Override
    public void start() {
        this.executor = Hazelcast.getExecutorService((String)this.name);
    }

    @Override
    public void stop() {
        this.executor = null;
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public Future<?> schedule(Runnable runnable, long delay, long period) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<T> schedule(Callable<T> callable, long delay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purge() {
    }

    @Override
    public int count() {
        return 0;
    }

    protected RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof DistributedCallable) {
            Object key = ((DistributedCallable)DistributedCallable.class.cast(callable)).getKey();
            if (key == null) {
                return new MultiTask(callable, Hazelcast.getCluster().getMembers());
            }
            if (key instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)InetSocketAddress.class.cast(key);
                Member target = Cluster.memberForAddress(address);
                if (target == null) {
                    throw new RejectedExecutionException("Address unavailable: " + address);
                }
                return new DistributedTask(callable, target);
            }
            return new DistributedTask(callable, key);
        }
        if (callable instanceof DistributedMasterCallable) {
            return new DistributedTask(callable, Cluster.masterMember());
        }
        if (callable instanceof DistributedLocalCallable) {
            return new DistributedTask(callable, Cluster.localMember());
        }
        return new DistributedTask(callable);
    }

    protected ExecutorService getExecutor() {
        return this.executor;
    }
}

