/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IXPathPairParameter;
import com.tandbergtv.workflow.adaptor.handler.XPathPairParameterImpl;
import com.tandbergtv.workflow.adaptor.handler.XPathRepeatParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathPairLoader {
    private static final String XPAIR_REPEAT_TAG_NAME = "/xPathConfiguration/RepeatMapping";
    private static final String XPAIR_SOURCE_TAG_NAME = "SourceXPath";
    private static final String XPAIR_DESTINATION_TAG_NAME = "DestinationXPath";
    private IHandlerConfiguration configuration;
    private static final ThreadLocal<XPath> t = new ThreadLocal<XPath>(){

        @Override
        protected XPath initialValue() {
            return XPathFactory.newInstance().newXPath();
        }
    };
    private static final ThreadLocal<DocumentBuilder> b = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };

    public XPathPairLoader(IHandlerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Deprecated
    public XPathRepeatParameter loadXPathRepeatParameter(String fileName) throws HandlerException {
        Node node;
        XPath xPath;
        XPathRepeatParameter repeat;
        block4: {
            repeat = null;
            DocumentBuilder db = b.get();
            db.reset();
            ClassLoader loader = this.configuration.getClassLoader();
            String configPath = this.configuration.getDefaultConfigPath();
            InputStream configStream = loader.getResourceAsStream(String.valueOf(configPath) + fileName);
            Document document = db.parse(configStream);
            xPath = t.get();
            xPath.reset();
            node = (Node)xPath.evaluate(XPAIR_REPEAT_TAG_NAME, document, XPathConstants.NODE);
            if (node != null) break block4;
            return null;
        }
        try {
            Node source = (Node)xPath.evaluate(XPAIR_SOURCE_TAG_NAME, node, XPathConstants.NODE);
            Node destination = (Node)xPath.evaluate(XPAIR_DESTINATION_TAG_NAME, node, XPathConstants.NODE);
            repeat = new XPathRepeatParameter(source.getTextContent(), destination.getTextContent());
            NodeList paths = (NodeList)xPath.evaluate("Mapping", node, XPathConstants.NODESET);
            int i = 0;
            while (i < paths.getLength()) {
                IXPathPairParameter pair = this.addNodeContentsToList(paths.item(i));
                repeat.addXPathPairParameter(pair);
                ++i;
            }
        }
        catch (Exception e) {
            throw new HandlerException("Failed to load document " + fileName, e);
        }
        return repeat;
    }

    public List<IXPathPairParameter> loadXPathPairs(String fileName) throws HandlerException {
        ArrayList<IXPathPairParameter> pairs = new ArrayList();
        try {
            DocumentBuilder db = b.get();
            db.reset();
            ClassLoader loader = this.configuration.getClassLoader();
            String configPath = this.configuration.getDefaultConfigPath();
            InputStream configStream = loader.getResourceAsStream(String.valueOf(configPath) + fileName);
            Document doc = db.parse(configStream);
            NodeList nodeSet = doc.getElementsByTagName("Mapping");
            pairs = this.addNodeContentsToList(nodeSet);
        }
        catch (SAXException ex) {
            throw new HandlerException("Could not parse DOM document.", ex);
        }
        catch (IOException ex) {
            throw new HandlerException("Could not read from mapping file.", ex);
        }
        return pairs;
    }

    private List<IXPathPairParameter> addNodeContentsToList(NodeList nodeSet) throws HandlerException {
        ArrayList<IXPathPairParameter> pairs = new ArrayList<IXPathPairParameter>();
        int i = 0;
        while (i < nodeSet.getLength()) {
            IXPathPairParameter pair = this.addNodeContentsToList(nodeSet.item(i));
            pairs.add(pair);
            ++i;
        }
        return pairs;
    }

    private IXPathPairParameter addNodeContentsToList(Node currentNode) throws HandlerException {
        NodeList children = currentNode.getChildNodes();
        String sourcePath = null;
        String destPath = null;
        int j = 0;
        while (j < children.getLength()) {
            if (children.item(j).getNodeName().equals(XPAIR_SOURCE_TAG_NAME)) {
                sourcePath = children.item(j).getTextContent();
            } else if (children.item(j).getNodeName().equals(XPAIR_DESTINATION_TAG_NAME)) {
                destPath = children.item(j).getTextContent();
            }
            ++j;
        }
        if (sourcePath == null || destPath == null) {
            throw new HandlerException("XPath Mapping file is invalid.");
        }
        return new XPathPairParameterImpl(sourcePath, destPath);
    }
}

