/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.sanmanager.entities;

public enum DriveCapacityUnit {
    BYTE,
    KILOBYTE,
    MEGABYTE,
    GIGABYTE,
    TERABYTE;

    private static final double UNIT_CONVERSION_BASE = 1024.0;

    public String toString() {
        String displayValue = null;
        switch (this) {
            case BYTE: {
                displayValue = "B";
                break;
            }
            case KILOBYTE: {
                displayValue = "KB";
                break;
            }
            case MEGABYTE: {
                displayValue = "MB";
                break;
            }
            case GIGABYTE: {
                displayValue = "GB";
                break;
            }
            case TERABYTE: {
                displayValue = "TB";
            }
        }
        return displayValue;
    }

    public static double convert(double capacity, DriveCapacityUnit unit, DriveCapacityUnit target) {
        if (unit == null) {
            String message = "The DriveCapacityUnit for the capacity to convert cannot be null.";
            throw new IllegalArgumentException(message);
        }
        if (target == null) {
            String message = "The DriveCapacityUnit to convert the capacity to cannot be null.";
            throw new IllegalArgumentException(message);
        }
        if (capacity < 0.0) {
            String message = "The Capacity value to convert cannot be negative.";
            throw new IllegalArgumentException(message);
        }
        if (unit == target) {
            return capacity;
        }
        double byteCapacity = DriveCapacityUnit.convertToBytes(capacity, unit);
        return DriveCapacityUnit.convertFromBytes(byteCapacity, target);
    }

    public static DriveCapacityUnit getBestDisplayUnit(long byteCount) {
        DriveCapacityUnit unit = BYTE;
        long divResult = byteCount / (long)Math.pow(1024.0, 4.0);
        if (divResult > 0L) {
            unit = TERABYTE;
        } else {
            divResult = byteCount / (long)Math.pow(1024.0, 3.0);
            if (divResult > 0L) {
                unit = GIGABYTE;
            } else {
                divResult = byteCount / (long)Math.pow(1024.0, 2.0);
                if (divResult > 0L) {
                    unit = MEGABYTE;
                } else {
                    divResult = byteCount / (long)Math.pow(1024.0, 1.0);
                    if (divResult > 0L) {
                        unit = KILOBYTE;
                    }
                }
            }
        }
        return unit;
    }

    private static double convertToBytes(double capacity, DriveCapacityUnit unit) {
        double convertedCapacity = capacity;
        switch (unit) {
            case KILOBYTE: {
                convertedCapacity *= Math.pow(1024.0, 1.0);
                break;
            }
            case MEGABYTE: {
                convertedCapacity *= Math.pow(1024.0, 2.0);
                break;
            }
            case GIGABYTE: {
                convertedCapacity *= Math.pow(1024.0, 3.0);
                break;
            }
            case TERABYTE: {
                convertedCapacity *= Math.pow(1024.0, 4.0);
            }
        }
        return convertedCapacity;
    }

    private static double convertFromBytes(double capacity, DriveCapacityUnit target) {
        double convertedCapacity = capacity;
        switch (target) {
            case KILOBYTE: {
                convertedCapacity /= Math.pow(1024.0, 1.0);
                break;
            }
            case MEGABYTE: {
                convertedCapacity /= Math.pow(1024.0, 2.0);
                break;
            }
            case GIGABYTE: {
                convertedCapacity /= Math.pow(1024.0, 3.0);
                break;
            }
            case TERABYTE: {
                convertedCapacity /= Math.pow(1024.0, 4.0);
            }
        }
        return convertedCapacity;
    }
}

