/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.KeypointPNGEncoderAdapter;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class ImageGenerator {
    public BufferedImage createImage(XYDataset data, String legend, String x, String y, int w, int h) {
        JFreeChart chart = null;
        if (data instanceof TimeSeriesCollection) {
            chart = this.createTimeSeriesChart(data, legend, x, y);
        } else if (data instanceof HistogramDataset) {
            chart = this.createHistogramChart(data, legend, x, y);
        }
        return this.createImage(chart, w, h);
    }

    public byte[] createImageBytes(XYDataset data, String legend, String x, String y, int w, int h) {
        JFreeChart chart = this.createTimeSeriesChart(data, legend, x, y);
        return this.createBytes(chart, w, h);
    }

    protected JFreeChart createTimeSeriesChart(XYDataset data, String legend, String x, String y) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)legend, (String)x, (String)y, (XYDataset)data, (boolean)true, (boolean)false, (boolean)false);
        return this.setDecoration(chart);
    }

    protected JFreeChart createHistogramChart(XYDataset data, String legend, String x, String y) {
        JFreeChart chart = ChartFactory.createHistogram((String)legend, (String)x, (String)y, (IntervalXYDataset)((IntervalXYDataset)data), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        return chart;
    }

    protected BufferedImage createImage(JFreeChart chart, int w, int h) {
        return chart.createBufferedImage(w, h, 2, null);
    }

    protected byte[] createBytes(JFreeChart chart, int w, int h) {
        byte[] buffer = null;
        KeypointPNGEncoderAdapter encoder = new KeypointPNGEncoderAdapter();
        encoder.setEncodingAlpha(true);
        try {
            buffer = encoder.encode(this.createImage(chart, w, h));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    protected JFreeChart setDecoration(JFreeChart chart) {
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        XYAreaRenderer renderer = new XYAreaRenderer();
        plot.setRenderer((XYItemRenderer)renderer);
        renderer.setSeriesPaint(0, (Paint)new Color(88, 128, 159));
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        if (plot.getDomainAxis() instanceof DateAxis) {
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        }
        ValueAxis vaxis = plot.getRangeAxis();
        vaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }
}

