/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.ui.chart;

import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.internal.FileSystemReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class DataSetGenerator {
    private File root;

    public DataSetGenerator(File root) {
        this.root = root;
    }

    public XYDataset createTimeSeries(Metric metric) {
        TimeSeries series = new TimeSeries((Comparable)((Object)metric.getName()), FixedMillisecond.class);
        List<Metric> metrics = new FileSystemReader(this.root).read(metric, 1L, TimeUnit.DAYS);
        for (Metric m : metrics) {
            series.add((RegularTimePeriod)new FixedMillisecond(m.getTime()), (double)m.getNumberValue().intValue());
        }
        return new TimeSeriesCollection(series);
    }

    public XYDataset createHistogram(Metric metricName) {
        HistogramDataset ds = new HistogramDataset();
        ds.setType(HistogramType.RELATIVE_FREQUENCY);
        List<Metric> metrics = new FileSystemReader(this.root).read(metricName, 1L, TimeUnit.DAYS);
        ArrayList<Double> values = new ArrayList<Double>();
        for (Metric metric : metrics) {
            values.add((Double)metric.getNumberValue());
        }
        ds.addSeries((Comparable)((Object)metricName.getName()), this.jesusWept(values), 6);
        return ds;
    }

    private double[] jesusWept(List<Double> list) {
        double[] array = new double[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }
}

