/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.DurationAware;
import com.tandbergtv.workflow.core.DurationUtility;
import com.tandbergtv.workflow.core.WFSInterpreter;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class DurationAggregator
implements NodeVisitor {
    private WFSInterpreter interpreter;
    private long total;
    private static final Logger logger = Logger.getLogger(DurationAggregator.class);

    public DurationAggregator(Token token) {
        this.interpreter = new WFSInterpreter(new ExecutionContext(token));
    }

    public Date getDuration() {
        return new Date(this.total);
    }

    public void visit(Node node) {
        String duration = null;
        if (node instanceof DurationAware) {
            duration = ((DurationAware)node).getDuration();
        }
        if (duration == null || duration.length() == 0) {
            return;
        }
        long time = 0L;
        try {
            time = new DurationUtility().getDurationInMillis(duration, this.interpreter);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to parse duration: " + duration + ", node " + node.getName()));
        }
        this.total += time;
    }
}

