/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.event;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.ResourceManagementEvent;
import org.jbpm.graph.def.Node;

public class ReleaseResourceEvent
extends ResourceManagementEvent
implements IResourceConsumerAware {
    private static final long serialVersionUID = 294763934800607636L;
    private long resourceId;
    private Long resourceGroupId;
    private CustomToken token;
    private Node node;

    public ReleaseResourceEvent(Object source, CustomToken token, Node node, Long resourceGroupId, Resource resource) {
        super(source);
        if (resource != null) {
            this.resourceId = resource.getId();
        }
        this.token = token;
        this.node = node;
        this.resourceGroupId = resourceGroupId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public Long getResourceGroupId() {
        return this.resourceGroupId;
    }

    public Node getNode() {
        return this.node;
    }

    public CustomToken getToken() {
        return this.token;
    }

    @Override
    public ResourceConsumerKey getResourceConsumerKey() {
        WorkflowProcess process = this.token.getProcessInstance();
        return new ResourceConsumerKey(this.token.getId(), process.getId(), this.resourceGroupId, null, process.getPriority());
    }

    public String toString() {
        return this.token + ", event RELEASE_RESOURCE";
    }
}

