/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcetype;

import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IResourceTypeService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalResourceTypeService
extends ResourceManagementService
implements IResourceTypeService,
IResourceManagementService {
    @Override
    public List<ResourceType> getAllResourceTypes() {
        ArrayList<ResourceType> resourceTypeList = new ArrayList<ResourceType>();
        IDistributedCache<ResourceType> cache = this.getResourceTypeCache();
        Collection keys = cache.localKeySet();
        for (Serializable key : keys) {
            ResourceType resourceType = (ResourceType)cache.get(key);
            if (!resourceType.isAvailable()) continue;
            resourceTypeList.add(this.clone(resourceType));
        }
        return resourceTypeList;
    }

    @Override
    public ResourceType getResourceType(long resourceTypeId) throws FinderException {
        ResourceType resourceType = null;
        IDistributedCache<ResourceType> cache = this.getResourceTypeCache();
        Collection keys = cache.localKeySet();
        if (keys.contains(resourceTypeId)) {
            resourceType = this.clone((ResourceType)cache.get((Serializable)Long.valueOf(resourceTypeId)));
        }
        if (resourceType == null) {
            String msg = "Could not find Resource Type with Id: " + resourceTypeId;
            throw new FinderException(msg);
        }
        return resourceType;
    }

    @Override
    public ResourceType getResourceTypeBySystemId(String systemId) {
        IDistributedCache<ResourceType> cache = this.getResourceTypeCache();
        Collection keys = cache.localKeySet();
        for (Serializable key : keys) {
            ResourceType resourceType = (ResourceType)cache.get(key);
            if (!resourceType.getSystemId().equals(systemId)) continue;
            return this.clone(resourceType);
        }
        return null;
    }

    private ResourceType clone(ResourceType resourceType) {
        return this.getService(ICloneService.class).cloneResourceType(resourceType);
    }

    private IDistributedCache<ResourceType> getResourceTypeCache() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    @Override
    public String getServiceName() {
        return "LocalResourceTypeService";
    }
}

