/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.dataaccess.hibernate;

import com.tandbergtv.workflow.dao.HibernateDAO;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ResourceHDAO
extends HibernateDAO<Resource, Long>
implements ResourceDAI {
    private static final Logger log = Logger.getLogger(ResourceHDAO.class);

    public ResourceHDAO(Session session) {
        super(Resource.class, session);
    }

    @Override
    public List<Resource> findByResourceType(long resourceTypeId) {
        Criteria criteria = this.createCriteria(new Criterion[0]).createCriteria("resourceType");
        criteria = criteria.add(Restrictions.idEq((Object)resourceTypeId));
        return this.findByCriteria(criteria);
    }

    @Override
    public List<Resource> findByResourceGroup(long resourceGroupId) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        criteria = criteria.createCriteria("resourceGroups");
        criteria = criteria.add(Restrictions.idEq((Object)resourceGroupId));
        return this.findByCriteria(criteria);
    }

    @Override
    public List<Resource> findByActive(boolean isActive) {
        log.debug((Object)("Finding Resources where 'active' is " + isActive + "..."));
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"active", (Object)isActive)});
        criteria.addOrder(Order.asc((String)"createDate"));
        List<Resource> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found Resources(" + activeList.size() + ") where 'active' is " + isActive));
        return activeList;
    }

    @Override
    public Resource findByName(String name) {
        if (name == null) {
            return null;
        }
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"name", (Object)name), Restrictions.eq((String)"active", (Object)true)});
        return (Resource)criteria.uniqueResult();
    }

    @Override
    public Resource findByUserName(String userName) {
        if (userName == null) {
            return null;
        }
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"userName", (Object)userName), Restrictions.eq((String)"active", (Object)true)});
        return (Resource)criteria.uniqueResult();
    }

    @Override
    public Resource findByConnectionString(String connectionString) {
        if (connectionString == null) {
            return null;
        }
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"connectionString", (Object)connectionString), Restrictions.eq((String)"active", (Object)true)});
        return (Resource)criteria.uniqueResult();
    }

    @Override
    public List<Resource> findBySearchCriteria(SearchCriteria searchCriteria) {
        String logString = "Finding all active Resources by Search Criteria using Ordering: ";
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            logString = String.valueOf(logString) + param.getSortingOrder() + " for property: ";
            logString = String.valueOf(logString) + param.getFieldName() + " ";
        }
        log.debug((Object)logString);
        Criteria criteria = this.createCriteria(new Criterion[]{Restrictions.eq((String)"active", (Object)true)});
        criteria.setFirstResult(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            criteria.setMaxResults(searchCriteria.getRecordsCount());
        }
        for (SearchParameterBase param : searchCriteria.getSearchList()) {
            if (param.getSortingOrder() == null) continue;
            String orderProperty = param.getFieldName();
            if ("resourceType".equals(orderProperty)) {
                criteria = criteria.createCriteria("resourceType");
                orderProperty = "name";
            }
            switch (param.getSortingOrder()) {
                case ASCENDING: {
                    criteria.addOrder(Order.asc((String)orderProperty));
                    break;
                }
                case DESCENDING: {
                    criteria.addOrder(Order.desc((String)orderProperty));
                }
            }
        }
        List<Resource> activeList = this.findByCriteria(criteria);
        log.debug((Object)("Found the Resources(" + activeList.size() + ") for the given Search Criteria."));
        return activeList;
    }

    @Override
    public Long findResourceTypeIDByKey(long resourceId) {
        String queryString = "SELECT resource.resourceType.id FROM Resource resource WHERE resource.id = :resourceId and resource.active = true";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceId", (Object)new Long(resourceId));
        return (Long)query.uniqueResult();
    }

    @Override
    public Long findResourceTypeIDByUserName(String userName) {
        if (userName == null) {
            return null;
        }
        String queryString = "SELECT resource.resourceType.id FROM Resource resource WHERE resource.userName = :userName and resource.active = true";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("userName", (Object)userName);
        return (Long)query.uniqueResult();
    }

    @Override
    public Long findResourceTypeIDByConnectionString(String connectionString) {
        if (connectionString == null) {
            return null;
        }
        String queryString = "SELECT resource.resourceType.id FROM Resource resource WHERE resource.connectionString = :connectionString and resource.active = true";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("connectionString", (Object)connectionString);
        return (Long)query.uniqueResult();
    }

    @Override
    public int countByActive() {
        String queryString = "SELECT count(resource) FROM Resource resource WHERE resource.active = true";
        Query query = this.getSession().createQuery(queryString);
        Long count = (Long)query.uniqueResult();
        return count.intValue();
    }

    @Override
    public int countByErrorStates() {
        String queryString = "SELECT count(resource) FROM Resource resource WHERE resource.active = true and resource.operationalStateId IN (:values)";
        Query query = this.getSession().createQuery(queryString);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(ResourceState.ERROR.getId());
        values.add(ResourceState.HEARTBEAT_ERROR.getId());
        values.add(ResourceState.INITIALIZATION_ERROR.getId());
        query.setParameterList("values", values);
        Long count = (Long)query.uniqueResult();
        return count.intValue();
    }

    @Override
    public boolean isNameUnique(Resource resource) {
        String queryString = "SELECT count(resource) FROM Resource resource WHERE resource.id != :resourceId and resource.active = true and resource.name = :name";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceId", (Object)new Long(resource.getId()));
        query.setParameter("name", (Object)resource.getName());
        Long count = (Long)query.uniqueResult();
        return count.intValue() == 0;
    }

    @Override
    public boolean isConnectionStringUnique(Resource resource) {
        String queryString = "SELECT count(resource) FROM Resource resource WHERE resource.id != :resourceId and resource.active = true and resource.connectionString = :connectionString";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceId", (Object)new Long(resource.getId()));
        query.setParameter("connectionString", (Object)resource.getConnectionString());
        Long count = (Long)query.uniqueResult();
        return count.intValue() == 0;
    }

    @Override
    public boolean isActive(long resourceId) {
        String queryString = "SELECT resource.active FROM Resource resource WHERE resource.id = :resourceId";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceId", (Object)new Long(resourceId));
        Boolean active = (Boolean)query.uniqueResult();
        return active == null ? false : active;
    }
}

