/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractHeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class WebserviceHBS
extends AbstractHeartBeatStrategy {
    private static final Logger hbLogger = Logger.getLogger(HTTPGetCommand.class);

    @Override
    protected Runnable getHeartBeatCommand() {
        return new HTTPGetCommand();
    }

    class HTTPGetCommand
    implements Runnable {
        HTTPGetCommand() {
        }

        @Override
        public void run() {
            Resource hbResource = WebserviceHBS.this.getResource();
            String connectionString = hbResource.getHeartbeatConnectionString();
            String name = "Resource[id=" + hbResource.getId() + "]: " + hbResource.getName();
            try {
                String errorMessage = null;
                Exception error = null;
                boolean isFailed = false;
                try {
                    this.getContent(connectionString);
                }
                catch (Exception ex) {
                    isFailed = true;
                    errorMessage = "HeartBeat Error for " + name + " when attempting to make HTTP Get call: " + ex.getMessage();
                    error = ex;
                }
                if (isFailed) {
                    ResourceHeartBeatEvent event = this.createEvent(errorMessage, error);
                    WebserviceHBS.this.fireHeartBeatFailureEvent(event);
                } else {
                    ResourceHeartBeatEvent event = this.createEvent(null, null);
                    WebserviceHBS.this.fireHeartBeatSuccessEvent(event);
                }
            }
            catch (Exception ex) {
                hbLogger.error((Object)("Failure in the HeartBeat Monitoring Thread for " + name + ", this should never happen."), (Throwable)ex);
            }
        }

        private ResourceHeartBeatEvent createEvent(String message, Throwable error) {
            ResourceHeartBeatEvent event = null;
            WebserviceHBS source = WebserviceHBS.this;
            Resource hbResource = WebserviceHBS.this.getResource();
            event = new ResourceHeartBeatEvent(source, hbResource, message, error);
            return event;
        }

        protected String getContent(String urlString) throws IOException {
            hbLogger.debug((Object)("Attempting to make HTTP Get call to url: " + urlString));
            String result = null;
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            result = this.readFromStream(connection.getInputStream());
            return result;
        }

        protected String readFromStream(InputStream stream) throws IOException {
            StringBuilder buf = new StringBuilder();
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                boolean firstLine = true;
                while ((line = reader.readLine()) != null) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        buf.append(System.getProperty("line.separator"));
                    }
                    buf.append(line);
                }
            }
            return buf.toString();
        }
    }
}

