/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class DistributedCache<T>
implements IDistributedCache<T> {
    private String name;
    private IMap<Serializable, T> map;
    private static final Logger logger = Logger.getLogger(DistributedCache.class);

    public DistributedCache(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public DistributedCache(String name, int size) {
        this.name = name;
        MapConfig config = new MapConfig(name);
        config.getMaxSizeConfig().setSize(size);
        config.setEvictionPolicy("LRU");
        Hazelcast.getConfig().addMapConfig(config);
    }

    @Override
    public String getServiceName() {
        return this.name;
    }

    @Override
    public void start() {
        this.map = Hazelcast.getMap((String)this.name);
        this.registerMigrationListener();
    }

    @Override
    public void stop() {
    }

    @Override
    public T get(Serializable key) {
        return (T)this.map.get((Object)key);
    }

    @Override
    public Collection<Serializable> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void add(Serializable key, T entity) {
        if (key == null || entity == null) {
            throw new IllegalArgumentException();
        }
        long start = System.currentTimeMillis();
        this.map.put((Object)key, entity);
        logger.debug((Object)("Time taken to DistributedCache().add() - time:" + (System.currentTimeMillis() - start)));
    }

    @Override
    public void remove(Serializable key) {
        long start = System.currentTimeMillis();
        this.map.remove((Object)key);
        logger.debug((Object)("Time taken to DistributedCache().remove() - time:" + (System.currentTimeMillis() - start)));
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public Collection<Serializable> localKeySet() {
        return this.map.localKeySet();
    }

    @Override
    public ConcurrentMap<Serializable, T> getMap() {
        return this.map;
    }

    protected void registerMigrationListener() {
        Hazelcast.getPartitionService().addMigrationListener(this.getMigrationListener());
    }

    protected MigrationListener getMigrationListener() {
        return new CacheKeyMigrationListener(this);
    }

    protected Set<Serializable> getLocalKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.localKeySet()) {
            if (Cluster.getPartitionId(key) != partitionId) continue;
            set.add(key);
        }
        return set;
    }

    protected class CacheKeyMigrationListener
    implements MigrationListener {
        protected final IDistributedCache<T> cache;

        public CacheKeyMigrationListener(IDistributedCache<T> cache) {
            this.cache = cache;
        }

        public void migrationStarted(MigrationEvent event) {
            if (this.wasPreviousOwner(event)) {
                Set<Serializable> set = Collections.emptySet();
                this.sendEvent(new PartitionEvent(this.cache, (EventObject)event, set, false));
            }
        }

        public void migrationCompleted(MigrationEvent event) {
            if (this.isNewOwner(event)) {
                Set<Serializable> set = DistributedCache.this.getLocalKeysInPartition(event.getPartitionId());
                boolean ownerAlive = Cluster.isMember(event.getOldOwner());
                if (!set.isEmpty()) {
                    this.sendEvent(new PartitionEvent(this.cache, (EventObject)event, set, true, ownerAlive));
                }
            }
        }

        protected void sendEvent(WorkflowEvent event) {
            DefaultMediator.getInstance().sendAsync(event);
        }

        protected boolean wasPreviousOwner(MigrationEvent me) {
            return Cluster.localMember().equals(me.getOldOwner());
        }

        protected boolean isNewOwner(MigrationEvent me) {
            return Cluster.localMember().equals(me.getNewOwner());
        }
    }
}

