/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.resource.ResourceGroup;
import com.tandbergtv.workflow.api.model.resource.ResourceGroupListResponse;
import com.tandbergtv.workflow.api.model.resource.ResourceGroupQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResourceGroups
extends AbstractClientRequest<ResourceGroupListResponse> {
    private String baseUrl;
    private ResourceGroupQueryBuilder query;

    ResourceGroups(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new ResourceGroupQueryBuilder(this.baseUrl);
    }

    @Override
    public ResourceGroupListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        Integer total = this.getTotal();
        if (total != null) {
            List list = (List)map.get("resourceGroups");
            return new ResourceGroupListResponse(this.getItems(list), total, this.getCount(), this.getPrevPageToken(), this.getNextPageToken());
        }
        ResourceGroup group = (ResourceGroup)Converters.forResourceGroup().apply(map);
        return new ResourceGroupListResponse(Collections.singletonList(group), 1, 1);
    }

    public ResourceGroupQueryBuilder query() {
        return this.query;
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<ResourceGroup> getItems(List<Map<String, Object>> map) {
        return Lists.transform(map, Converters.forResourceGroup());
    }
}

