/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api.model.process;

import com.google.common.base.Preconditions;
import com.tandbergtv.workflow.api.model.AbstractQueryBuilder;
import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProcessQueryBuilder
extends AbstractQueryBuilder {
    private static final String FORMAT = "yyyy-MM-dd";
    private ProcessStatus[] status;
    private String template;
    private String startDate;
    private String titleId;
    private String providerId;
    private String cutoff;
    private static final String PATH = "processes";

    public ProcessQueryBuilder(String baseUrl) {
        super(baseUrl, PATH);
    }

    public ProcessQueryBuilder(String baseUrl, String path) {
        super(baseUrl, path);
    }

    public ProcessQueryBuilder status(ProcessStatus ... status) {
        this.status = (ProcessStatus[])Preconditions.checkNotNull((Object)status);
        String string = new String();
        for (ProcessStatus s : this.status) {
            string = string + (Object)((Object)s) + ",";
        }
        this.ub = this.ub.queryParam("status", new Object[]{string});
        return this;
    }

    public ProcessQueryBuilder template(String template) {
        this.template = (String)Preconditions.checkNotNull((Object)template);
        this.ub = this.ub.queryParam("templateName", new Object[]{this.template});
        return this;
    }

    public ProcessQueryBuilder startDate(Date date) {
        this.startDate = new SimpleDateFormat(FORMAT).format((Date)Preconditions.checkNotNull((Object)date));
        this.ub = this.ub.queryParam("startDate", new Object[]{this.startDate});
        return this;
    }

    public ProcessQueryBuilder titleId(String titleId) {
        this.titleId = (String)Preconditions.checkNotNull((Object)titleId);
        this.ub = this.ub.queryParam("titleId", new Object[]{this.titleId});
        return this;
    }

    public ProcessQueryBuilder providerId(String providerId) {
        this.providerId = (String)Preconditions.checkNotNull((Object)providerId);
        this.ub = this.ub.queryParam("providerId", new Object[]{this.providerId});
        return this;
    }

    public ProcessQueryBuilder statistics(Date date) {
        this.cutoff = new SimpleDateFormat(FORMAT).format((Date)Preconditions.checkNotNull((Object)date));
        this.ub = this.ub.path("statistics").queryParam("start", new Object[]{this.cutoff});
        return this;
    }

    @Override
    public String build() {
        return this.ub.build(new Object[0]).toASCIIString();
    }

    public static enum Parameter {
        DETAIL,
        STATUS,
        STARTDATE,
        ENDDATE,
        TEMPLATENAME,
        SORT,
        ORDER,
        START,
        COUNT;

    }
}

