/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.model.process.ProcessQueryBuilder;
import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import com.tandbergtv.workflow.api.model.process.StatisticsResponse;
import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;

public class Statistics
extends AbstractClientRequest<StatisticsResponse> {
    private String baseUrl;
    private ProcessQueryBuilder query;

    Statistics(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new ProcessQueryBuilder(this.baseUrl);
    }

    public ProcessQueryBuilder query() {
        return this.query;
    }

    @Override
    public StatisticsResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        EnumMap<ProcessStatus, Long> stats = new EnumMap<ProcessStatus, Long>(ProcessStatus.class);
        for (String key : map.keySet()) {
            ProcessStatus status = ProcessStatus.valueOf(key.toUpperCase());
            if (!map.containsKey(key)) continue;
            stats.put(status, Long.valueOf(map.get(key).toString()));
        }
        return new StatisticsResponse(stats);
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }
}

