/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.api;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.api.AbstractClientRequest;
import com.tandbergtv.workflow.api.Converters;
import com.tandbergtv.workflow.api.model.process.Template;
import com.tandbergtv.workflow.api.model.process.TemplateListResponse;
import com.tandbergtv.workflow.api.model.process.TemplateQueryBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Templates
extends AbstractClientRequest<TemplateListResponse> {
    private String baseUrl;
    private TemplateQueryBuilder query;

    Templates(String baseUrl) {
        this.baseUrl = baseUrl;
        this.query = new TemplateQueryBuilder(this.baseUrl);
    }

    public TemplateQueryBuilder query() {
        return this.query;
    }

    @Override
    public TemplateListResponse execute() throws IOException {
        Map<String, Object> map = this.request();
        Integer total = this.getTotal();
        if (total != null) {
            List list = (List)map.get("templates");
            return new TemplateListResponse(this.getItems(list), total, this.getCount(), this.getPrevPageToken(), this.getNextPageToken());
        }
        Template template = (Template)Converters.forTemplate().apply(map);
        return new TemplateListResponse(Collections.singletonList(template), 1, 1);
    }

    @Override
    protected URL url() throws IOException {
        return new URL(this.query.build());
    }

    private List<Template> getItems(List<Map<String, Object>> list) {
        return Lists.transform(list, Converters.forTemplate());
    }
}

