/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.internal.AuthorizationManager;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.log.file.ResourceEventHistoryRemover;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.internal.MetricProcessor;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.util.resource.InternalResourceService;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class Activator {
    private static final String SETTINGS_GROUP = "com.tandbergtv.workflow.application";
    private static final String PERIOD = "history.resourceEvent.retention.days";
    private static final String RESOURCE_TYPE_IDS = "com.tandbergtv.workflow.resource.systemids";
    private static final String DEFAULT_SYSTEM_IDS = "CM,PM,re,SM,ut,CG,ct,fs";
    private static final int DEFAULT_HISTORY_PERIOD = 7;
    private static final String MBEAN_QUERY = "com.tandbergtv.watchpoint:type=Queue,*";

    public void start() {
        ManagementService.registerMBeans((CacheManager)CacheManager.getInstance(), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new AuthorizationManager(factory));
        String systemIds = null;
        int period = 7;
        ISettingsProvider provider = new SettingsPluginLoader().createSettingsProvider();
        if (provider != null) {
            Map<String, String> settings = provider.getProperties(SETTINGS_GROUP);
            systemIds = settings.get(RESOURCE_TYPE_IDS) == null ? DEFAULT_SYSTEM_IDS : settings.get(RESOURCE_TYPE_IDS);
            period = settings.get(PERIOD) == null ? period : Integer.parseInt(settings.get(PERIOD));
        }
        this.addService((Service)this.scheduleResourceEventHistoryRemover(period));
        this.addService((Service)new ResourceManager(factory, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addService((Service)new InternalResourceService(this.getResourceTypes(systemIds)));
        this.addObserver();
    }

    public void stop() {
        this.removeService("resource-event-log-delete");
        this.removeService(ResourceManagement.class);
        this.removeService(IInternalResourceService.class);
        this.removeService(IAuthorizationManager.class);
        CacheManager.getInstance().shutdown();
    }

    private ISchedulerService<Void> scheduleResourceEventHistoryRemover(int period) {
        Scheduler scheduler = new Scheduler("resource-event-log-delete", 1, 1);
        scheduler.schedule((Runnable)new ResourceEventHistoryRemover(period), 0L, TimeUnit.DAYS.toMillis(1L));
        return scheduler;
    }

    private Collection<String> getResourceTypes(String property) {
        if (property == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(property.split(","));
    }

    private void addObserver() {
        IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup("fs-recorder");
        try {
            IObserver observer = Observers.localJMXObserver((String)MBEAN_QUERY, (String)"Size");
            recorder.addObserver(observer);
            this.getService(MetricProcessor.class).addMetricNames(observer.getMetricNames());
        }
        catch (JMException e) {
            Logger.getLogger(Activator.class).warn((Object)":(", (Throwable)e);
        }
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = this.getService(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = ServiceRegistry.getDefault().lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

