/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.util.ApplicationProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EngineDriverProperties
extends Properties {
    private static final long serialVersionUID = 1991050875737707033L;
    private static final String DRIVER_PROPERTIES_FILE = "engineDriver.properties";
    public static final String PLUGIN_SETTINGS_PATH = "com.tandbergtv.workflow.application";
    private String filePath;
    private static final Logger LOGGER = Logger.getLogger(EngineDriverProperties.class);

    public EngineDriverProperties() {
        SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
        ISettingsProvider provider = settingsPluginLoader.createSettingsProvider();
        if (provider != null) {
            this.loadPropertiesFromPlugin(provider);
        } else {
            this.loadPropertiesFromFile();
        }
    }

    private void loadPropertiesFromFile() {
        String configPath = null;
        try {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            configPath = properties.getProperty("WorkflowApp.ConfigPath");
            if (configPath != null) {
                configPath = configPath.trim();
            }
        }
        catch (IOException ioe) {
            String msg = "Cannot store: engineDriver.properties, failed to read the Application Properties and read value for key: WorkflowApp.ConfigPath";
            LOGGER.error((Object)msg, (Throwable)ioe);
            return;
        }
        this.filePath = configPath + File.separator + DRIVER_PROPERTIES_FILE;
        File driverPropertiesFile = new File(this.filePath);
        LOGGER.debug((Object)("The Driver Properties File: " + driverPropertiesFile.getAbsolutePath()));
        if (!driverPropertiesFile.exists()) {
            try {
                this.setDefaults();
                this.save();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Failed to write properties to the Engine Driver Properties file: " + this.getPropertiesFilePath()), (Throwable)ex);
            }
        } else {
            try {
                this.load();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Failed to read any existing Engine Driver Properties file: " + this.getPropertiesFilePath() + ", using default property values."), (Throwable)ex);
            }
        }
    }

    private void loadPropertiesFromPlugin(ISettingsProvider provider) {
        if (provider != null) {
            Map<String, String> map = provider.getProperties(PLUGIN_SETTINGS_PATH);
            for (String key : map.keySet()) {
                this.setProperty(key, map.get(key));
            }
        }
    }

    private void setDefaults() {
        this.setProperty("isDriverHalted", "false");
        this.setProperty("no.retry.on.recovery", "false");
        this.setProperty("log.level", LogLevel.ALL.toString());
    }

    @Override
    public String getProperty(String key) {
        if ("driver.properties.file".equals(key)) {
            return this.filePath;
        }
        return super.getProperty(key);
    }

    public void store() throws IOException {
        this.save();
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.save();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.save();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    private synchronized void load() throws IOException {
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(this.filePath));
            this.load(inStream);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    private synchronized void save() throws IOException {
        LOGGER.debug((Object)"Saving properties");
        SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
        ISettingsProvider provider = settingsPluginLoader.createSettingsProvider();
        if (provider != null) {
            LOGGER.debug((Object)("Saving " + this.getProperty("isDriverHalted")));
            this.saveToPlugin(provider);
        } else {
            this.saveToFile();
        }
    }

    private void saveToPlugin(ISettingsProvider provider) {
        try {
            provider.saveSingleSetting(PLUGIN_SETTINGS_PATH, "isDriverHalted", this.getProperty("isDriverHalted"));
            LOGGER.debug((Object)("Saved " + this.getProperty("isDriverHalted")));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error updating setting: isDriverHalted=" + this.getProperty("isDriverHalted")), (Throwable)e);
        }
    }

    private void saveToFile() throws FileNotFoundException, IOException {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.filePath));
            super.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)"Failed to close the Engine Driver Properties File Stream.", (Throwable)ex);
                }
            }
        }
    }

    private String getPropertiesFilePath() {
        return this.filePath;
    }
}

