/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.userprovider;

import com.tandbergtv.workflow.auth.IUserProvider;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.userprovider.IUserProviderService;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class UserProviderService
implements IUserProviderService {
    private static final Logger LOGGER = Logger.getLogger(UserProviderService.class);
    private static final String UI_PLUGIN_NAME = "com.tandbergtv.workflow.ui";
    private static final String USER_PROVIDER_EXTENSION_POINT = "users";

    public String getServiceName() {
        return UserProviderService.class.getName();
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public IUserProvider getUserProvider() {
        Collection<Extension> extensions;
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        try {
            extensions = UserProviderService.getUserProviderExtensions(pluginManager);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"It wasn't possible to load the User Provider extension.", (Throwable)e);
            return null;
        }
        if (extensions.size() == 0) {
            LOGGER.debug((Object)"No User Provider plugin defined.");
            return null;
        }
        if (extensions.size() > 1) {
            LOGGER.warn((Object)"More than one User Provider specified. The first one will be used. Check the plugins configuration.");
        }
        Extension firstExtension = extensions.iterator().next();
        return UserProviderService.getUserProviderInstance(pluginManager, firstExtension);
    }

    private static Collection<Extension> getUserProviderExtensions(PluginManager pluginManager) throws PluginLifecycleException {
        PluginRegistry pluginRegistry = pluginManager.getRegistry();
        pluginManager.getPlugin(UI_PLUGIN_NAME);
        ExtensionPoint extentionPoint = pluginRegistry.getExtensionPoint(UI_PLUGIN_NAME, USER_PROVIDER_EXTENSION_POINT);
        Collection extensions = extentionPoint.getAvailableExtensions();
        return extensions;
    }

    private static IUserProvider getUserProviderInstance(PluginManager pluginManager, Extension extension) {
        PluginDescriptor plugin = extension.getDeclaringPluginDescriptor();
        PluginClassLoader loader = pluginManager.getPluginClassLoader(plugin);
        try {
            Class<?> pluginClass = loader.loadClass(extension.getParameter("class").valueAsString());
            return (IUserProvider)pluginClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"It wasn't possible to load the User Provider plugin.", (Throwable)e);
            return null;
        }
    }
}

