/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.coder;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ExtendedTransition;
import com.tandbergtv.workflow.core.util.Reflection;
import com.tandbergtv.workflow.driver.template.coder.TemplateNodeResourceBinder;
import com.tandbergtv.workflow.driver.template.coder.TransitionWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class TransitionSerializer
extends FSTBasicObjectSerializer {
    private static final Logger LOGGER = Logger.getLogger(TransitionSerializer.class);
    TemplateNodeResourceBinder binder = TemplateNodeResourceBinder.get();

    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        ExtendedTransition transition = (ExtendedTransition)toWrite;
        WorkflowTemplate template = (WorkflowTemplate)transition.getProcessDefinition();
        out.writeLong(transition.getId());
        this.writeString(out, template.getFullName());
        this.writeString(out, this.toName(transition.getFrom()));
        this.writeString(out, this.toName(transition.getTo()));
        this.writeString(out, transition.getName());
        out.writeObject((Object)transition.getEvents());
        out.writeObject((Object)transition.getExceptionHandlers());
        this.verifyNode(transition, template);
    }

    private void verifyNode(ExtendedTransition transition, WorkflowTemplate template) {
        if (transition.getFrom() != null && template.findNode(this.toName(transition.getFrom())) == null) {
            this.findNode(transition.getFrom(), template);
        }
        if (transition.getTo() != null && template.findNode(this.toName(transition.getTo())) == null) {
            this.findNode(transition.getTo(), template);
        }
    }

    private void findNode(Node node, WorkflowTemplate template) {
        this.binder.initTemplateNodeInfo(template);
        this.binder.findBindedNode(template, node.getName());
        this.binder.verifyActionClass(node);
    }

    private String toName(Node node) {
        return node == null ? "" : node.getName();
    }

    public void readObject(FSTObjectInput in, Object toRead, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy) throws Exception {
    }

    public boolean alwaysCopy() {
        return true;
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        List handlers;
        long id = in.readLong();
        String templateFullname = this.readString(in);
        String fromNodeName = this.readString(in);
        String toNodeName = this.readString(in);
        String name = this.readString(in);
        ExtendedTransition transition = new ExtendedTransition(name);
        Reflection.reflectSetProtectedFieldValue((Object)id, (Object)transition, (String)"id");
        Map events = (Map)in.readObject();
        if (events != null) {
            for (Object key : events.keySet()) {
                transition.addEvent((Event)events.get(key));
            }
        }
        if ((handlers = (List)in.readObject()) != null) {
            for (Object object : handlers) {
                transition.addExceptionHandler((ExceptionHandler)object);
            }
        }
        this.binder.cacheTransition(templateFullname, new TransitionWrapper((Transition)transition, fromNodeName, toNodeName));
        return transition;
    }

    private String readString(FSTObjectInput in) throws IOException {
        String value = in.readUTF();
        return value == null || "NULL".equals(value) ? null : value;
    }

    private void writeString(FSTObjectOutput out, String value) throws IOException {
        out.writeUTF(value == null ? "NULL" : value);
    }
}

