/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class WorkflowMessageFactory {
    private static final String FACTORY_IMPL = "com.tandbergtv.workflow.message.impl.WorkflowMessageFactoryImpl";

    private static WorkflowMessageFactory newInstance() {
        String className = FACTORY_IMPL;
        WorkflowMessageFactory instance = null;
        try {
            Class<?> clazz = WorkflowMessageFactory.class.getClassLoader().loadClass(className);
            instance = (WorkflowMessageFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Factory class " + className + " could not be instantiated", e);
        }
        return instance;
    }

    public static WorkflowMessage createControlMessage(String uid) {
        return WorkflowMessageFactory.newInstance().createControlMessageImpl(uid);
    }

    public static WorkflowMessage createControlMessage(String uid, ExecutionContext ec) {
        return WorkflowMessageFactory.newInstance().createControlMessageImpl(uid, ec);
    }

    public static WorkflowMessage createAckMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.newInstance().createWorkflowMessageImpl(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
    }

    public static WorkflowMessage createNackMessage(WorkflowMessage message) {
        return WorkflowMessageFactory.newInstance().createWorkflowMessageImpl(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.nack);
    }

    protected abstract WorkflowMessage createControlMessageImpl(String var1);

    protected abstract WorkflowMessage createControlMessageImpl(String var1, ExecutionContext var2);

    protected abstract WorkflowMessage createWorkflowMessageImpl(IMessageUID var1, IMessageKey var2, WorkflowMessage.MessageType var3);
}

