/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.util;

import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.MarshalException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Marshaller {
    private static final ThreadLocal<DocumentBuilder> BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                return factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };
    private static final Logger LOGGER = Logger.getLogger(Marshaller.class);

    private Marshaller() {
    }

    public static Marshaller newMarshaller() {
        return new Marshaller();
    }

    public Document marshal(WorkflowMessage message) throws MarshalException {
        Document document = null;
        String type = message.getType().toString();
        String uid = message.getMessageUID().getUID();
        String requestKey = new String();
        String origin = new String();
        if (message.getKey() != null) {
            requestKey = message.getKey().toString();
        }
        if (message.getOrigin() != null) {
            origin = message.getOrigin().toString();
        }
        try {
            DocumentBuilder builder = BUILDER.get();
            builder.reset();
            document = builder.newDocument();
            Element root = this.createRootElement(document, uid, type, requestKey, origin);
            document.appendChild(root);
            this.marshalProperties(document, message);
            if (message.getCommand() != null) {
                this.marshalCommand(message.getCommand(), document);
            }
            if (message.getPayload() != null) {
                this.marshalPayload(root, message.getPayload());
            }
        }
        catch (Exception e) {
            throw new MarshalException("Failed to marshal the document", e);
        }
        return document;
    }

    private Element createRootElement(Document document, String uid, String type, String requestKey, String origin) {
        Element root = this.createElement(document, "WFSMessage");
        root.setAttribute("UID", uid);
        root.setAttribute("Type", type);
        root.setAttribute("RequestKey", requestKey);
        root.setAttribute("MessageOrigin", origin);
        Element body = this.createElement(document, "MessageBody");
        Element params = this.createElement(document, "ParameterList");
        body.appendChild(params);
        root.appendChild(body);
        return root;
    }

    private void marshalPayload(Element root, WorkflowPayload payload) {
        Node parameters = root.getElementsByTagName("ParameterList").item(0);
        for (String name : payload.getParameterNames()) {
            this.marshalParameter(parameters, name, payload.getParameterValue(name));
        }
    }

    protected void marshalParameter(Node parameters, String name, Object value) {
        if (value instanceof List) {
            Element e = this.createElement(parameters.getOwnerDocument(), "Parameter");
            e.setAttribute("DataType", "List");
            e.setAttribute("Name", name);
            parameters.appendChild(e);
            List list = (List)value;
            int i = 0;
            while (i < list.size()) {
                Object item = list.get(i);
                this.marshalParameter(e, this.indexedName(name, i), item);
                ++i;
            }
        } else {
            this.marshal(parameters, name, value);
        }
    }

    protected String indexedName(String name, int index) {
        return String.valueOf(name) + "[" + index + "]";
    }

    private void marshal(Node element, String key, Object value) {
        String string = value != null ? value.toString() : "";
        this.marshal(element, key, string, "String");
    }

    private void marshal(Node element, String key, String value, String type) {
        Document document = element.getOwnerDocument();
        Element param = this.createElement(document, "Parameter");
        param.setAttribute("DataType", type);
        param.setAttribute("Name", key);
        Element e = this.createElement(document, "Value");
        if (value != null && value.indexOf(60) >= 0 && value.indexOf(62) >= 0) {
            e.appendChild(document.createCDATASection(value));
        } else {
            e.setTextContent(value);
        }
        param.appendChild(e);
        element.appendChild(param);
    }

    private Element createElement(Document document, String name) {
        return document.createElement(name);
    }

    private void marshalProperties(Document doc, WorkflowMessage wfsMessage) {
        Element sourceElement = this.createSourceElement(doc, wfsMessage.getSource());
        if (sourceElement != null) {
            doc.getDocumentElement().appendChild(sourceElement);
        } else {
            LOGGER.debug((Object)"No source element present");
        }
        Element responseDestinationElement = this.createResponseDestinationElement(doc, wfsMessage.getResponseDestination());
        if (responseDestinationElement != null) {
            doc.getDocumentElement().appendChild(responseDestinationElement);
        } else {
            LOGGER.debug((Object)"No response destination present");
        }
    }

    public Element createSourceElement(Document doc, ISource source) {
        Element deviceInfoElement;
        Element sourceElement = null;
        if (source != null && (deviceInfoElement = this.createDeviceElement(doc, source)) != null) {
            sourceElement = this.createElement(doc, "Source");
            sourceElement.setAttribute("Name", source.getName());
            sourceElement.appendChild(deviceInfoElement);
        }
        return sourceElement;
    }

    public Element createResponseDestinationElement(Document doc, IDestination responseDestination) {
        Element deviceInfoElement;
        Element responseDestinationElement = null;
        if (responseDestination != null && (deviceInfoElement = this.createDeviceElement(doc, responseDestination)) != null) {
            responseDestinationElement = this.createElement(doc, "ResponseDestination");
            responseDestinationElement.appendChild(deviceInfoElement);
        }
        return responseDestinationElement;
    }

    private Element createDeviceElement(Document doc, IDevice device) {
        Element deviceInfoElement = null;
        if (device instanceof HTTPDevice) {
            Element sourceUrlElement = this.createElement(doc, "URL");
            String url = ((HTTPDevice)device).getUrl();
            sourceUrlElement.setTextContent(url);
            deviceInfoElement = sourceUrlElement;
        } else if (device instanceof TCPDevice) {
            Element sourceHostElement = this.createElement(doc, "Host");
            String ip = ((TCPDevice)device).getIP();
            int port = ((TCPDevice)device).getPort();
            sourceHostElement.setAttribute("IP", ip);
            sourceHostElement.setAttribute("Port", Integer.toString(port));
            deviceInfoElement = sourceHostElement;
        }
        return deviceInfoElement;
    }

    private void marshalCommand(WPCLCommand command, Document document) {
        Element e = document.createElement("Command");
        e.setAttribute("Name", command.getName());
        for (String key : command.getParameters().keySet()) {
            Element parameter = document.createElement("CommandParameter");
            parameter.setAttribute("Name", key);
            parameter.setAttribute("Value", command.getParameterValue(key));
            e.appendChild(parameter);
        }
        document.getDocumentElement().appendChild(e);
    }
}

