/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import java.util.Date;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class WFSVariableInstance
extends VariableInstance {
    private static final long serialVersionUID = -2694761215146430102L;
    private String classType;
    private String stringVal;
    private Date dateVal;
    private Double doubleVal;
    private Long longVal;

    public WFSVariableInstance() {
    }

    public WFSVariableInstance(String classType, String stringVal, Date dateVal, Double doubleVal, Long longVal, String name) {
        this.classType = classType;
        this.stringVal = stringVal;
        this.dateVal = dateVal;
        this.doubleVal = doubleVal;
        this.longVal = longVal;
        this.name = name;
    }

    public Object getObject() {
        Datatype type = Datatype.valueOf(this.getClassType().toUpperCase());
        switch (type) {
            case STRING: {
                return this.getStringVal();
            }
            case LONG: {
                return this.getLongVal();
            }
            case DOUBLE: {
                return this.getDoubleVal();
            }
            case DATE: {
                return this.getDateVal();
            }
        }
        return null;
    }

    public void setObject(Object value) {
        Datatype type = Datatype.valueOf(this.getClassType().toUpperCase());
        String val = String.valueOf(value);
        switch (type) {
            case STRING: {
                this.setStringVal(val);
                break;
            }
            case LONG: {
                this.setLongVal(Long.valueOf(val));
                break;
            }
            case DOUBLE: {
                this.setDoubleVal(Double.valueOf(val));
                break;
            }
            case DATE: {
                long timeStamp = Long.parseLong(val);
                this.setDateVal(new Date(timeStamp));
                break;
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public void setTokenVariableMap(TokenVariableMap tokenVariableMap) {
        this.tokenVariableMap = tokenVariableMap;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public Date getDateVal() {
        return this.dateVal;
    }

    public Double getDoubleVal() {
        return this.doubleVal;
    }

    public String getStringVal() {
        return this.stringVal;
    }

    public Long getLongVal() {
        return this.longVal;
    }

    public String getClassType() {
        return this.classType;
    }

    public boolean isStorable(Object value) {
        return false;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    private void setStringVal(String stringVal) {
        this.stringVal = stringVal;
    }

    private void setDateVal(Date dateVal) {
        this.dateVal = dateVal;
    }

    private void setDoubleVal(Double doubleVal) {
        this.doubleVal = doubleVal;
    }

    private void setLongVal(Long longVal) {
        this.longVal = longVal;
    }
}

