/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapper;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapperFactory;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class WorkflowProcessCache
extends CompositeCache<WorkflowProcess> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcessCache.class);
    public static final String CACHE_NAME = "Process Cache";

    public WorkflowProcessCache(String name, int size) {
        super(name, size);
    }

    private void assertArgument(Serializable key, WorkflowProcess entity) {
        Assert.notNull((Object)key, (String)"Key cannot be null");
        Assert.notNull((Object)entity, (String)"WorkflowProcess cannot be null");
        Assert.isTrue((boolean)(key instanceof Long), (String)"Key have to be long value");
    }

    public void add(Serializable key, WorkflowProcess entity) {
        this.assertArgument(key, entity);
        this.cache.add(key, (Object)entity);
        this.addCentralizedCache(key, entity);
    }

    public void cache(long key, WorkflowProcess entity) {
        this.add((Serializable)Long.valueOf(key), entity);
    }

    public void cache(long id, WorkflowProcess entity, boolean l2CacheOnly) {
        if (l2CacheOnly) {
            this.addCentralizedCache(Long.valueOf(id), entity);
        } else {
            this.cache(id, entity);
        }
    }

    public void uncache(long key) {
        this.remove(Long.valueOf(key));
    }

    private void addCentralizedCache(Serializable key, WorkflowProcess entity) {
        WorkflowProcessCacheWrapper cachedEntity = WorkflowProcessCacheWrapperFactory.create(entity);
        LOGGER.debug((Object)("Cache the Process Object" + (Object)((Object)cachedEntity) + " into hazelcast."));
        this.getMap().put(key, cachedEntity);
    }

    public WorkflowProcess get(Serializable key) {
        WorkflowProcessCacheWrapper wrapper;
        WorkflowProcess entity = (WorkflowProcess)this.cache.get(key);
        if (entity == null && (wrapper = (WorkflowProcessCacheWrapper)((Object)this.getMap().get(key))) != null) {
            entity = WorkflowProcessCacheWrapperFactory.create(wrapper);
        }
        return entity;
    }
}

