/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.entity.WorkflowProcessDTO;
import com.tandbergtv.workflow.core.util.HibernateTemplate;
import com.tandbergtv.workflow.core.util.SessionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WorkflowProcessDTOService {
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcessDTOService.class);
    private SessionFactory sessionFactory;

    public WorkflowProcessDTOService(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void create(WorkflowProcessDTO dto) {
        LOGGER.debug((Object)("WorkflowProcessDTO is saved to datebase: " + dto.toString()));
        Session session = this.sessionFactory.getCurrentSession();
        session.save((Object)dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowProcessDTO get(Long id) {
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            WorkflowProcessDTO workflowProcessDTO = (WorkflowProcessDTO)session.load(WorkflowProcessDTO.class, (Serializable)id);
            return workflowProcessDTO;
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)("Cannot load Process Object by id:" + id + " error:" + e.getMessage()));
            WorkflowProcessDTO workflowProcessDTO = null;
            return workflowProcessDTO;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkflowProcessDTO> getAllInTopLevel(List<Serializable> ids) {
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        ArrayList result = Lists.newArrayList();
        try {
            List processes;
            Criteria criteria = session.createCriteria(WorkflowProcessDTO.class).add(Restrictions.in((String)"id", ids)).add((Criterion)Restrictions.gt((String)"parentId", (Object)0L)).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setProjection((Projection)Projections.property((String)"parentId"));
            List parentProcessIdSet = criteria.list();
            LinkedHashSet searchIdSet = Sets.newLinkedHashSet(ids);
            if (!CollectionUtils.isEmpty((Collection)parentProcessIdSet)) {
                searchIdSet.addAll(parentProcessIdSet);
            }
            if (!CollectionUtils.isEmpty((Collection)(processes = (criteria = session.createCriteria(WorkflowProcessDTO.class).add(Restrictions.in((String)"id", (Collection)searchIdSet)).add((Criterion)Restrictions.eq((String)"parentId", (Object)0L)).addOrder(Order.asc((String)"id"))).list()))) {
                result.addAll(processes);
            }
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowProcessDTO getLatestSubProcess(Long parentProcessId, Long parentTokenId) {
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            Query query = session.createQuery("SELECT wp FROM WorkflowProcessDTO wp WHERE wp.parentId = ? and wp.parentId >0 and wp.rootTokenId in (select t.tokenId from CustomTokenDTO t where t.parentTokenId=?) order by wp.id desc");
            query.setParameter(0, (Object)parentProcessId);
            query.setParameter(1, (Object)parentTokenId);
            List processDTOs = query.list();
            WorkflowProcessDTO workflowProcessDTO = (WorkflowProcessDTO)Iterables.getFirst((Iterable)processDTOs, null);
            return workflowProcessDTO;
        }
        finally {
            SessionUtils.closeSession((org.hibernate.Session)session);
        }
    }

    public void save(WorkflowProcessDTO dto) {
        LOGGER.debug((Object)("WorkflowProcessDTO is updated to datebase: " + dto.toString()));
        Session session = this.sessionFactory.getCurrentSession();
        session.merge((Object)dto);
    }

    public WorkflowProcessDTO getByCreateId(String createId) {
        if (StringUtils.isEmpty((Object)createId)) {
            return null;
        }
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        Criteria criteria = session.createCriteria(WorkflowProcessDTO.class).add((Criterion)Restrictions.eq((String)"createId", (Object)createId));
        return (WorkflowProcessDTO)criteria.uniqueResult();
    }

    public Boolean createIdExists(String createId) {
        if (StringUtils.isEmpty((Object)createId)) {
            return false;
        }
        org.hibernate.Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        Criteria criteria = session.createCriteria(WorkflowProcessDTO.class).add((Criterion)Restrictions.eq((String)"createId", (Object)createId)).setProjection((Projection)Projections.countDistinct((String)"id"));
        Integer count = HibernateTemplate.toInteger((Object)criteria.uniqueResult());
        return count > 0 ? Boolean.TRUE : Boolean.FALSE;
    }
}

