/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.IPersistenceService;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class SignalSuperProcessToken
extends TokenCallable {
    private long childPid;
    private static final long serialVersionUID = 3251238469812711918L;

    public SignalSuperProcessToken(CustomToken token, boolean usePid) {
        super(token);
        this.childPid = token.getSubProcessInstance().getId();
        if (usePid) {
            this.key = Long.valueOf(this.getPid());
        }
    }

    @Override
    public CustomToken call() throws Exception {
        CustomToken token = this.findToken();
        if (!this.isSuperProcessToken(token)) {
            Logger.getLogger(SignalSuperProcessToken.class).warn((Object)(token + ", does not have child " + this.childPid));
            return token;
        }
        try {
            IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
            WorkflowProcess child = service.get((Serializable)Long.valueOf(this.childPid));
            child.setSuperProcessToken((Token)token);
            token.setSubProcessInstance((ProcessInstance)child);
            token.signal2();
        }
        catch (Throwable t) {
            Logger.getLogger(SignalSuperProcessToken.class).error((Object)(token + ", child " + this.childPid), t);
        }
        return token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        if (process == null) {
            return false;
        }
        return this.childPid == process.getId();
    }
}

