/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.entity.TaskInstanceDTO;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;
import org.springframework.util.CollectionUtils;

public class TaskInstanceConvertor {
    private ISequenceIdGenerator idGenerator;
    private static final Logger logger = Logger.getLogger(TaskInstanceConvertor.class);

    public TaskInstanceConvertor(ISequenceIdGenerator taskInstanceIdGenerator) {
        this.idGenerator = taskInstanceIdGenerator;
    }

    public TaskInstanceDTO findNewManualTaskInstance(WorkflowProcess process) {
        if (CollectionUtils.isEmpty((Collection)process.getTaskMgmtInstance().getTaskInstances())) {
            return null;
        }
        TaskInstance newTi = null;
        for (Object ti : process.getTaskMgmtInstance().getTaskInstances()) {
            TaskInstance taskInstance = (TaskInstance)ti;
            CustomToken token = (CustomToken)taskInstance.getToken();
            Boolean isNotPersisted = taskInstance.getId() <= 0L;
            if (!TaskInstanceConvertor.isManualTaskRunning(process, token, taskInstance) || !isNotPersisted.booleanValue()) continue;
            newTi = taskInstance;
            newTi.setId(this.idGenerator.queryId());
            break;
        }
        return TaskInstanceConvertor.toTaskInstanceDto(newTi);
    }

    private static boolean isManualTaskRunning(WorkflowProcess process, CustomToken token, TaskInstance taskInstance) {
        return TaskInstanceConvertor.isManualTaskFound(process, taskInstance, token.getId()) && TaskInstanceConvertor.isCurrentlyManualTask(token);
    }

    private static boolean isCurrentlyManualTask(CustomToken token) {
        return token.getCurrentNode() instanceof ManualTaskNode;
    }

    private static TaskInstanceDTO toTaskInstanceDto(TaskInstance instance) {
        if (instance == null) {
            return null;
        }
        TaskInstanceDTO instanceDto = new TaskInstanceDTO();
        instanceDto.setTaskId(instance.getId());
        instanceDto.setTokenId(instance.getToken().getId());
        instanceDto.setCurrentNodeName(instance.getTask().getName());
        instanceDto.setStartTime(instance.getStart());
        instanceDto.setEndTime(instance.getEnd());
        return instanceDto;
    }

    public List<TaskInstanceDTO> findManualTaskInstances(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        if (CollectionUtils.isEmpty((Collection)process.getTaskMgmtInstance().getTaskInstances())) {
            return Collections.emptyList();
        }
        ArrayList<TaskInstanceDTO> dtos = new ArrayList<TaskInstanceDTO>();
        for (Object ti : process.getTaskMgmtInstance().getTaskInstances()) {
            boolean isForTargetToken;
            TaskInstance taskInstance = (TaskInstance)ti;
            long tokenIdOnTask = taskInstance.getToken().getId();
            boolean bl = isForTargetToken = tokenIdOnTask == token.getId();
            if (!TaskInstanceConvertor.isManualTaskFound(process, taskInstance, tokenIdOnTask) || !isForTargetToken) continue;
            dtos.add(TaskInstanceConvertor.toTaskInstanceDto(taskInstance));
        }
        return dtos;
    }

    private static boolean isManualTaskFound(WorkflowProcess process, TaskInstance taskInstance, long tokenId) {
        return process.findToken(tokenId) != null && taskInstance.getTask().getTaskNode() instanceof ManualTaskNode;
    }

    public void rebuildManualTask(CustomToken token, TaskInstanceDTO manualInstanceDto) {
        if (manualInstanceDto == null) {
            logger.debug((Object)("The Manual Task Instance for Token: " + token.toString() + " may has ended."));
            return;
        }
        WorkflowProcess process = token.getProcessInstance();
        String taskName = manualInstanceDto.getCurrentNodeName();
        logger.debug((Object)("Rebuild manual task instance from dto object, task name: (" + taskName + ") Token: " + token.toString()));
        Task task = process.getProcessDefinition().getTaskMgmtDefinition().getTask(taskName);
        ExecutionContext executionContext = new ExecutionContext((Token)token);
        executionContext.setTask(task);
        TaskMgmtInstance tmi = process.getTaskMgmtInstance();
        TaskInstance manualInstance = tmi.createTaskInstance(task, (org.jbpm.graph.exe.ExecutionContext)executionContext);
        manualInstance.setId(manualInstanceDto.getTaskId());
        manualInstance.setEnd(manualInstanceDto.getEndTime());
    }

    public void rebuildManualTasks(CustomToken customToken, List<TaskInstanceDTO> taskInstances) {
        if (CollectionUtils.isEmpty(taskInstances)) {
            logger.debug((Object)("No Manual Task Instances for Token: " + customToken.toString()));
            return;
        }
        for (TaskInstanceDTO manualInstanceDto : taskInstances) {
            this.rebuildManualTask(customToken, manualInstanceDto);
        }
    }
}

